/*
 * listner.h
 *
 *  Created on: 2012/07/04
 *      Author: Yasuoki
 */

#ifndef LISTNER_H_
#define LISTNER_H_

#include "../include/sst_types.h"
#include <event2/event.h>

namespace SST {

class ListenerPool
{
public:
	ListenerPool();
	~ListenerPool();

	bool run(Sentinel *sentinel);
	void stop();
	bool waitData(Session *con);

protected:
	class Listener {
	public:
		Listener();
		~Listener();

		bool	run(ListenerPool *pool);
		void	stop();

		static void	connectProc(int fd, short event, void *args);
		static void	recvProc(int fd, short event, void *args);

	protected:
		static void *threadEntry(void *);
		void	*mainLoop();
		bool			doStop;
		ListenerPool *	pool;
		pthread_t 		threadHandle;
		pthread_t*		threadHandlePtr;
	};

	void	clear();

	int	fd;
	Sentinel *			sentinel;
	struct event_base *	listenBase;
	struct event	*	listenEvent;

	Listener *			pListener;
	int					nListener;
};

}

#endif /* LISTNER_H_ */
