/*
 * message.h
 *
 *  Created on: 2012/07/30
 *      Author: tanaka
 */

#ifndef MESSAGE_H_
#define MESSAGE_H_

#include "../include/sst_types.h"
#include "buffer.h"

namespace SST {

class Message {
public:
	Message();
	~Message();

	void			clear();

	bool			setURL(const char *url);
	const char *	getURL() const { return pURL; }

	bool			setScheme(const char *scheme);
	const char *	getScheme() const { return pScheme; }

	bool			addHeader(const char *name, const char *value);
	bool			setHeader(const char *name, const char *value);
	size_t			getHeaderCount();
	const NamedValue *getHeader(size_t index);
	const char *	getHeaderValue(const char *name);

	bool			addParam(const char *name, const char *value);
	size_t			getParamCount();
	const NamedValue *getParam(size_t index);
	const char *	getParamValue(const char *name);

	bool			addContent(const char *data, size_t size);
	bool			setContent(const char *data, size_t size);
	size_t			getContentSize();
	const char *	getContent();

protected:
	const char *	pURL;
	const char *		pScheme;
	int				status;
	size_t			bHeader;
	size_t			nHeader;
	NamedValue *	pHeader;
	size_t			bParam;
	size_t			nParam;
	NamedValue *	pParam;
	CyclicBuffer	content;
	StaticBuffer	values;
};

}

#endif /* MESSAGE_H_ */
