/*
 * processor.h
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#ifndef PROCESSOR_H_
#define PROCESSOR_H_

#include "../include/sst_types.h"
#include "commands.h"
#include "queue.h"
#include "pjson.h"
#include <pthread.h>

namespace SST {

class ProcessorPool {
public:
	ProcessorPool();
	~ProcessorPool();

	bool run(Sentinel *sentinel);
	void stop();

	class Processor {
	public:
		Processor();
		~Processor();

		bool	run(ProcessorPool *pool);
		void	stop();
		void	wait();
		size_t 	testCb(char* ptr, size_t size, size_t nmemb);

	protected:
		static void *threadEntry(void *ptr);
		void	*mainLoop();

		void	cmdError(Session *con, CMDStatus code, const char *fmt, ...);
		bool	response(Session *con, pjson::builder &js);
		bool	loginPrompt(Session *con);

		bool	acceptProc(QueueNode *q);
		bool	sessionDataProc(QueueNode *q);
		bool	commandProc(QnSessionCommand *q);
		bool	responseProc(QnResponse *q);

		bool	cmdLoginProc(QnSessionCommand *q, pjson::json *js);
		bool	cmdUserProc(QnSessionCommand *q, pjson::json *js);
		bool	cmdUsersProc(QnSessionCommand *q, pjson::json *js);
		bool	cmdGroupsProc(QnSessionCommand *q, pjson::json *js);
		bool	cmdServicesProc(QnSessionCommand *q, pjson::json *js);
		bool	cmdResourcesProc(QnSessionCommand *q, pjson::json *js);
		bool	cmdResourceInfoProc(QnSessionCommand *q, pjson::json *js);
		bool	cmdJoinGroupProc(QnSessionCommand *q, pjson::json *js);

		bool	cmdTestProc(QnSessionCommand *q, pjson::json *js);

		ProcessorPool *pool;
		bool		doStop;
		pthread_t 	threadHandle;
		pthread_t*	threadHandlePtr;
	};
protected:

	void clear();

	Sentinel *			sentinel;
	size_t				nProcessor;
	Processor *			pProcessor;
};

}

#endif /* PROCESSOR_H_ */
