/*
 * requester.h
 *
 *  Created on: 2012/07/30
 *      Author: tanaka
 */

#ifndef REQUESTER_H_
#define REQUESTER_H_

#include "../include/sst_types.h"
#include "queue.h"
#include "commands.h"
#include <pthread.h>

namespace SST {

class Requester {
public:
	Requester();
	~Requester();

	void	clear();
	bool	configure(Sentinel *obj, Conf *conf);
	bool 	run(Sentinel *obj);
	void 	stop();
	bool	putRequest(QnRequest *r);

protected:
	class RequestProcessor {
	public:
		RequestProcessor(Requester * requester);
		~RequestProcessor();

		bool	run();
		void	stop();
		void	wait();
		static void *threadEntry(void *ptr);
		void	*mainLoop();

		bool		process(QnRequest *q);
		bool		cancelProcess();
		Message	*	getResponse() { return response; }
		size_t		writeCB(char* ptr, size_t size, size_t nmemb);

		static size_t pxWriteCB(char* ptr, size_t size, size_t nmemb, void* data);

		Requester *	requester;

		Message	*	request;
		Message *	response;

		bool		doCancel;
		bool		doStop;
		pthread_t 	threadHandle;
		pthread_t*	threadHandlePtr;
		QnRequest *curNode;
	};

	Sentinel *			sentinel;
	size_t				nProcessor;
	RequestProcessor **	pProcessor;
	Queue				queue;
};

}


#endif /* REQUESTER_H_ */
