/*
 * service.cpp
 *
 *  Created on: 2012/07/18
 *      Author: tanaka
 */

#include "sentinel.h"
#include "service.h"
#include "resource.h"
#include "database.h"
#include <malloc.h>
#include <memory.h>

namespace SST {

Service::Service()
{
	sentinel		= NULL;
	serviceId[0]	= 0;
	serviceName		= NULL;
	ownerId			= NULL;
	bGroup			= 0;
	nGroup			= 0;
	pGroup			= 0;
	bResources		= 0;
	nResources		= 0;
	pResources		= NULL;
}

Service::~Service()
{
	if( serviceName ) 	free(serviceName);
	if( ownerId )		free(ownerId);
	size_t i;
	for( i = 0; i < nResources; i++ ) {
		delete pResources[i];
	}
}

bool Service::configure(Sentinel *obj, const char *id)
{
	sentinel	= obj;
	strcpy(serviceId, id);
	return true;
}

bool Service::run()
{
	sentinel->log(LOG_DEBUG, "Service::run 1");
	Database *db = sentinel->getDatabase();
	ServiceInfo *pInfo;
	if( db->getServiceInfo(serviceId, &pInfo) != DBErrorOk ) {
		sentinel->log(LOG_DEBUG, "Service::run 2");
		return false;
	}
	sentinel->log(LOG_DEBUG, "Service::run 3");
	free(pInfo);
	sentinel->log(LOG_DEBUG, "Service::run ok");
	return true;
}

void Service::stop()
{

}

ServiceStatus Service::getServiceStatus() const
{
	Database *db = sentinel->getDatabase();
	ServiceStatus st;
	if( db->getServiceStatus(serviceId, st) != DBErrorOk ) {
		return ServiceError;
	}
	return st;
}

ServiceInfo * Service::getServiceInfo() const
{
	Database *db = sentinel->getDatabase();
	ServiceInfo *pInfo;
	if( db->getServiceInfo(serviceId, &pInfo) != DBErrorOk ) {
		return NULL;
	}
	return pInfo;
}

const char * Service::getParticipationGroupId(size_t index) const
{
	return pGroup[index];
}


bool Service::getResource(size_t nFrom, RecList *pList) const
{
	Database *db = sentinel->getDatabase();
	if( db->getResourceList(serviceId, nFrom, pList) != DBErrorOk ) {
		free(pList);
		return false;
	}
	return true;
}

bool Service::isServiceParticipation(const char *userId) const
{
	Database *db = sentinel->getDatabase();
	size_t 	nFrom = 0;
	RecList *pGroupList;
	pGroupList = (RecList*)malloc(sizeof(RecList)+sizeof(char)*(SST_USERIDLEN+1)*32+sizeof(char*)*32);
	if( !pGroupList ) {
		sentinel->log(LOG_ERR, "Out of memory at user list");
		return false;
	}
	pGroupList->nSize	= sizeof(RecList)+sizeof(char)*(SST_USERIDLEN+1)*32;
	pGroupList->nCount	= 32;
	pGroupList->nValues	= 0;
	do {
		if( db->getServiceGroupList(serviceId, nFrom, pGroupList) != DBErrorOk ) {
			free(pGroupList);
			return false;
		}
		size_t i;
		for( i = 0; i < pGroupList->nValues; i++ ) {
			size_t 	nFrom = 0;
			RecList *pUserGroupList;
			pUserGroupList = (RecList*)malloc(sizeof(RecList)+sizeof(char)*(SST_USERIDLEN+1)*32);
			if( !pUserGroupList ) {
				sentinel->log(LOG_ERR, "Out of memory at user list");
				free(pGroupList);
				return false;
			}
			pUserGroupList->nSize	= sizeof(RecList)+sizeof(char)*(SST_USERIDLEN+1)*32;
			pUserGroupList->nCount	= 32;
			pUserGroupList->nValues	= 0;
			do {
				if( db->getParticipationGroupList(userId, nFrom, pUserGroupList) != DBErrorOk ) {
					free(pGroupList);
					free(pUserGroupList);
					return false;
				}
				size_t n;
				for( n = 0; n < pUserGroupList->nValues; n++ ) {
					if( strcmp(pUserGroupList->pValue[n], pGroupList->pValue[i]) == 0 ) {
						free(pGroupList);
						free(pUserGroupList);
						return true;
					}
				}
				nFrom += pUserGroupList->nValues;
			} while( pUserGroupList->nValues == 32 );
			free(pUserGroupList);
		}
		nFrom += pGroupList->nValues;
	} while( pGroupList->nValues == 32 );
	free(pGroupList);
	return false;
}

//////////////////////////////////
Services::Services()
{
	bNodes	= 0;
	nNodes	= 0;
	pNodes	= NULL;
}

Services::~Services()
{
	clear();
}

void Services::clear()
{
	size_t i;
	for( i = 0; i < nNodes; i++ ) {
		delete pNodes[i];
	}
	free(pNodes);
	nNodes	= 0;
	bNodes	= 0;
	pNodes	= NULL;
}

bool Services::configure(Sentinel *obj, Conf *conf)
{
	sentinel = obj;
	return true;
}

bool Services::run()
{
	sentinel->log(LOG_DEBUG, "Services::run 1");
	Database *db = sentinel->getDatabase();

	size_t nSvc;
	if( db->getServiceCount(nSvc) != DBErrorOk ) {
		return false;
	}
	sentinel->log(LOG_DEBUG, "Services::run 2");
	pNodes	= (Service**)malloc(sizeof(Service*)*nSvc);
	if( !pNodes ) {
		sentinel->log(LOG_ERR, "Out of memory at service list");
		return false;
	}
	bNodes	= nSvc;
	nNodes	= 0;
	sentinel->log(LOG_DEBUG, "Services::run 3");

	RecList *pList = (RecList*)malloc(sizeof(RecList)+sizeof(char)*(SST_SERVICEIDLEN+1)*32+sizeof(char*)*32);
	if( !pList ) {
		sentinel->log(LOG_ERR, "Out of memory at service list");
		return false;
	}
	pList->nSize	= sizeof(RecList)+sizeof(char)*(SST_SERVICEIDLEN+1)*32+sizeof(char*)*32;
	pList->nCount	= 32;
	pList->nValues	= 0;
	sentinel->log(LOG_DEBUG, "Services::run 4");

	size_t nFrom=0;
	size_t i;
	while( nNodes < nSvc ) {
		if( db->getServiceList(nFrom, pList) != DBErrorOk ) {
			free(pList);
			sentinel->log(LOG_DEBUG, "Services::run 41");
			return false;
		}
		for( i = 0; i < pList->nValues; i++ ) {
			Service *ptr = new Service();
			if( !ptr ) {
				free(pList);
				sentinel->log(LOG_ERR, "Out of memory at service instance");
				return false;
			}
			if( !ptr->configure(sentinel, pList->pValue[i]) ) {
				free(pList);
				sentinel->log(LOG_DEBUG, "Services::run 42");
				return false;
			}
			pNodes[nNodes++] = ptr;
		}
		nFrom += pList->nValues;
	}
	sentinel->log(LOG_DEBUG, "Services::run 5");

	for( i = 0; i < nNodes; i++ ) {
		if( !pNodes[i]->run() ) {
			return false;
		}
	}
	sentinel->log(LOG_DEBUG, "Services::run 6");
	return true;
}

void Services::stop()
{
	size_t i;
	for( i = 0; i < nNodes; i++ ) {
		pNodes[i]->stop();
	}
}


}
