/*
 * connection.cpp
 *
 *  Created on: 2012/07/03
 *      Author: yasuoki
 */
#include <memory.h>
#include <malloc.h>
#include <syslog.h>

#define _XOPEN_SOURCE
#include <unistd.h>
#include <crypt.h>

#include "session.h"
#include "sentinel.h"

namespace SST {

Session::Session()
{
	inUse		= false;
	fd			= 0;
	accountId[0]= 0;
	userId[0]	= 0;
	chatRoom[0]	= 0;
	recvEvent	= NULL;
	prevList	= NULL;
	nextList	= NULL;
	status		= SessionStatusWait;
	srand((unsigned int)time(NULL));
}

Session::~Session()
{
}

bool  Session::open(Sentinel *sentinel, int fd, sockaddr_in *addr)
{
	this->sentinel	= sentinel;
	this->inUse		= true;
	this->fd		= fd;
	memcpy((void*)&this->addr, (void*)addr, sizeof(addr));
	this->status	= SessionStatusAccept;
	return true;
}

void Session::close()
{
	if( fd ) ::close(fd);
	fd	= 0;
	readBuff.clear();
	writeBuff.clear();
	inUse	= false;
	if( recvEvent ) {
		struct event *e = recvEvent;
		recvEvent	= NULL;
		event_free(e);
	}
	status	= SessionStatusWait;
}

static const char *hex64="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
char *base64(char *src, int len, char *dest, int destLen)
{
	char *p1 = dest;
	while( len >= 3 ) {
		if( destLen < 5 ) return NULL;
		char c0 = *src++;
		char c1 = *src++;
		char c2 = *src++;
		*p1++ = hex64[(c0>>2)&0x3f];
		*p1++ = hex64[((c0<<4)&0x30)|((c1>>4)&0xf)];
		*p1++ = hex64[((c1<<2)&0x3c)|((c2>>6)&0x3)];
		*p1++ = hex64[c2&0x3f];
		len 	-= 3;
		destLen -= 4;
	}
	if( len == 1 ) {
		if( destLen < 5 ) return NULL;
		char c0 = *src++;
		*p1++ = hex64[(c0>>2)&0x3f];
		*p1++ = hex64[(c0<<4)&0x30];
		*p1++ = '=';
		*p1++ = '=';
	}
	if( len == 2 ) {
		if( destLen < 5 ) return NULL;
		char c0 = *src++;
		char c1 = *src++;
		*p1++ = hex64[(c0>>2)&0x3f];
		*p1++ = hex64[((c0<<4)&0x30)|((c1>>4)&0xf)];
		*p1++ = hex64[(c1<<2)&0x3c];
		*p1++ = '=';
	}
	*p1 = 0;
	return dest;
}

char * Session::createNonce()
{
	int hex[8];
	for( int i=0; i< 8; i++ ) {
		hex[i] = rand();
	}
	char b64hex[sizeof(hex)*2];
	base64((char*)hex, sizeof(hex), b64hex, sizeof(b64hex));
	char *key = crypt(b64hex, "$1$z4$zz4p");
	sentinel->log(LOG_DEBUG, "nonce=%s %s\n", key, b64hex);
	strcpy(nonce, &key[6]);
	return nonce;
}

char *  Session::getLastNonce()
{
	return nonce;
}

struct event *Session::assignEvent(struct event_base *base, event_callback_fn fn)
{
	if( recvEvent ) {
		event_assign(recvEvent, base, fd, EV_READ, fn, this);
	} else {
		recvEvent = event_new(base, fd, EV_READ, fn, this);
	}
	return recvEvent;
}

/////////////////////////////////////////////
SessionPool::SessionPool()
{
	useList		= NULL;
	freeList	= NULL;
	nSize		= 0;
	nUse		= 0;
	nFree		= 0;
}

SessionPool::~SessionPool()
{
	clear();
}

void  SessionPool::clear()
{
	while( useList ) {
		freeSession(useList);
	}
	Session *p = freeList;
	while(p) {
		Session *n = p->nextList;
		delete p;
		p = n;
	}
	nSize	= 0;
	nUse	= 0;
	nFree	= 0;
	useList		= NULL;
	freeList	= NULL;
}

bool SessionPool::configure(Sentinel *obj, Conf *conf)
{
	sentinel	= obj;
	nSize	= conf->maxConnections;
	if( nSize < nUse + nFree ) {
		while(nSize < nUse + nFree && nFree > 0) {
			Session *p = freeList;
			Session *n = p->nextList;
			n->prevList	= NULL;
			freeList	= n;
			nFree--;
			delete p;
		}
	}
	size_t nAdd = nSize - ( nUse + nFree);
	while( nAdd > 0 ) {
		Session *p = new Session();
		if( p == NULL ) {
			return false;
		}
		p->nextList	= freeList;
		if( freeList )
			freeList->prevList	= p;
		freeList	= p;
		nFree++;
		nAdd--;
	}
	return true;
}

void SessionPool::freeSession(Session *con)
{
	con->close();
	Session *p = con->prevList;
	Session *n = con->nextList;

	if( p )
		p->nextList = n;
	else
		useList		= n;
	if( n )
		n->prevList = p;

	con->prevList	= NULL;
	con->nextList	= freeList;
	if( freeList )
		freeList->prevList = con;
	nUse--;
	nFree++;
}

Session *SessionPool::getSession()
{
	Session *a = freeList;
	Session *n = a->nextList;
	if( n )
		n->prevList = NULL;
	freeList	= n;

	Session *u = useList;
	if( u )
		u->prevList	= a;
	a->nextList	= u;
	useList		= a;
	nUse++;
	nFree--;
	return a;
}

Session * SessionPool::getUse()
{
	return useList;
}

Session * SessionPool::getNext(Session *con)
{
	return con->nextList;
}

}


