/*
 * session.h
 *
 *  Created on: 2012/06/05
 *      Author: yasuoki
 */

#ifndef SESSION_H_
#define SESSION_H_

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <event2/event.h>
#include "../include/sst_types.h"
#include "buffer.h"

namespace SST {

class Session {
public:
	friend class SessionPool;
	Session();
	Session(const Session &c);
	~Session();
	Session &operator=(const Session &c);

	Sentinel *	getSentinel() { return sentinel; }
	Link &		getLink();
	bool		open(Sentinel *sentinel, int fd, sockaddr_in *addr);
	void 		close();

	SessionStatus	getStatus() { return status; }
	void		setStatus(SessionStatus s) { status = s; }

	char *		createNonce();
	char *		getLastNonce();
	bool		setUserId(char *id) { strcpy(userId, id); return true; }
	char *		getUserId() { return userId[0] == 0 ? NULL : userId; }
	bool		setAccountId(char *id) { strcpy(accountId, id); return true; }
	char *		getAccountId() { return accountId[0] == 0 ? NULL : accountId; }

	bool		setChatRoom(const char *name) { strcpy(chatRoom, name); return true; }
	bool		exitChatRoom() { chatRoom[0] = 0; return true; }
	const char * getChatRoom() { return chatRoom[0]?chatRoom:NULL; }

	int			getDiscriptor() { return fd; }
	struct event *assignEvent(struct event_base *base, event_callback_fn fn);

	Buffer *	getReadBuffer() { return &readBuff; }
	Buffer *	getWriteBuffer() { return &writeBuff; }

protected:
	Sentinel *	sentinel;
	bool		inUse;
	sockaddr_in addr;
	int			fd;
	struct event *	recvEvent;
	CyclicBuffer	readBuff;
	CyclicBuffer	writeBuff;
	char		nonce[24];
	char		accountId[12];
	char		userId[12];
	char		chatRoom[20];

	SessionStatus	status;

	Session *prevList;
	Session *nextList;
};

class SessionPool {
public:
	SessionPool();
	~SessionPool();

	void		clear();
	bool		configure(Sentinel *obj, Conf *conf);
	void		freeSession(Session *con);
	Session *	getSession();

	Session *	getUse();
	Session *	getNext(Session *con);
	size_t		getCapacity() const { return nSize; }
	size_t		getActiveSessions() const { return nUse; }

protected:
	Sentinel *	sentinel;
	Session *	useList;
	Session *	freeList;
	size_t		nSize;
	size_t		nUse;
	size_t		nFree;
};

}

#endif /* SESSION_H_ */
