/*
 * cmd_upsync.cpp
 *
 *  Created on: 2013/03/22
 *      Author: yasuoki
 */

#include "commands.h"
#include "proc_command.h"
#include "proc_database.h"
#include "proc_requester.h"
#include "proc_listener.h"
#include "task.h"
#include "sentinel.h"
#include "buffer.h"
#include "pjson.h"
#include <syslog.h>
#include <errno.h>
#include <netdb.h>
#include <assert.h>
#include <curl/curl.h>

namespace SST {

class TBUpSync: public TaskBuffer {
public:
	enum {
		SYNC_RESOURCE_CREATE		= 1,
		SYNC_RESOURCE_UPDATETAG		= 2,
		SYNC_RESOURCE_UPDATEBODY	= 3,
		SYNC_RESOURCE_REMOVE		= 4,
		SYNC_GADGET_CREATE			= 5,
		SYNC_GADGET_UPDATETAG		= 6,
		SYNC_GADGET_UPDATEBODY		= 7,
		SYNC_GADGET_REMOVE			= 8,
	};
	TBUpSync() {
		mJsCommand		= NULL;
		mJsMode			= NULL;
		mJsSID			= NULL;
		mJsMID			= NULL;
		mJsSName		= NULL;
		mJsRID			= NULL;
		mJsRName		= NULL;
		mJsGName		= NULL;
		mJsSize			= NULL;
		mJsTag			= NULL;
		mJsServerTime	= NULL;
		mJsServerRev	= NULL;
		mJsDeviceTime	= NULL;
		mJsDeviceRev	= NULL;

		mMode			= 0;
		mHasBody		= false;
		mHasTag			= false;
		mExtResource	= false;
		mExtGadget		= false;
		mModResource	= false;
		mData			= NULL;
		mService		= NULL;
		mResource		= NULL;
		mShare			= NULL;
	}
	virtual ~TBUpSync() {
		if( mJsCommand )	delete mJsCommand;
		if( mData )			delete mData;
		if( mService )		free(mService);
		if( mResource )		free(mResource);
		if( mShare )		free(mShare);
	}

	pjson::json *	mJsCommand;
	pjson::value *	mJsMode;
	pjson::value *	mJsMID;
	pjson::value *	mJsSID;
	pjson::value *	mJsSName;
	pjson::value *	mJsRID;
	pjson::value *	mJsRName;
	pjson::value *	mJsGName;
	pjson::value *	mJsSize;
	pjson::value *	mJsTag;
	pjson::value *	mJsServerTime;
	pjson::value *	mJsServerRev;
	pjson::value *	mJsDeviceTime;
	pjson::value *	mJsDeviceRev;

	int		mMode;
	bool	mHasBody;
	bool	mHasTag;
	bool	mExtResource;
	bool	mExtGadget;
	bool	mModResource;
	StdBuffer *mData;

	ResultService *	mService;
	ResultResource *mResource;
	ResultShare *	mShare;
};

bool CommandProc::cmdUpSync(QueueNode *q)
{
	Task *task	= q->getTask();
	int step	= q->getStep();

	TBUpSync *tb = (TBUpSync*)task->getTaskBuffer();
	if( tb == NULL ) {
		tb = new TBUpSync();
		if( tb == NULL ) {
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
		if( !task->setTaskBuffer(tb) ) {
			delete tb;
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
	}

	switch(step) {
	case 0:
		{
			tb->mJsCommand = q->detouchJSONMessage();
			pjson::value *vCmd = tb->mJsCommand->get("upSync");
			if( vCmd->vt != pjson::vt_object ) {
				return taskResponse(q, ErrorParameter, "%s. \"upSync\" is not object.", codeToMessgae(ErrorParameter));
			}

			tb->mJsMode			= tb->mJsCommand->get("mode", vCmd);
			tb->mJsMID			= tb->mJsCommand->get("shareId", vCmd);
			tb->mJsSID			= tb->mJsCommand->get("sid", vCmd);
			tb->mJsSName		= tb->mJsCommand->get("serviceName", vCmd);
			tb->mJsRID			= tb->mJsCommand->get("rid", vCmd);
			tb->mJsRName		= tb->mJsCommand->get("resourceName", vCmd);
			tb->mJsGName		= tb->mJsCommand->get("gadgetName", vCmd);
			tb->mJsSize			= tb->mJsCommand->get("size", vCmd);
			tb->mJsTag			= tb->mJsCommand->get("tag", vCmd);
			tb->mJsServerTime	= tb->mJsCommand->get("serverTime", vCmd);
			tb->mJsServerRev	= tb->mJsCommand->get("serverRevision", vCmd);
			tb->mJsDeviceTime	= tb->mJsCommand->get("deviceTime", vCmd);
			tb->mJsDeviceRev	= tb->mJsCommand->get("deviceRevision", vCmd);

			if( tb->mJsMode && tb->mJsMode->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"mode\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsMID && tb->mJsMID->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"shareId\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsSID && tb->mJsSID->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"sid\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsSName&& tb->mJsSName->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"serviceName\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsRName && tb->mJsRName->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"resourceName\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsGName && tb->mJsGName->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"gadgetName\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsSize && tb->mJsSize->vt != pjson::vt_int ) {
				return taskResponse(q, ErrorParameter, "%s. \"size\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsTag && tb->mJsTag->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"tag\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsServerTime && tb->mJsServerTime->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"serverTime\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsServerRev && tb->mJsServerRev->vt != pjson::vt_int ) {
				return taskResponse(q, ErrorParameter, "%s. \"serverRevision\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsDeviceTime && tb->mJsDeviceTime->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"deviceTime\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsDeviceRev && tb->mJsDeviceRev->vt != pjson::vt_int ) {
				return taskResponse(q, ErrorParameter, "%s. \"deviceRevision\" type.", codeToMessgae(ErrorParameter));
			}

			if( tb->mJsMode == NULL ) {
				return taskResponse(q, ErrorParameter, "%s. \"mode\" value.", codeToMessgae(ErrorParameter));
			}
			if( strcmp(tb->mJsMode->vString, "create_resource") == 0 ) {
				tb->mMode			= TBUpSync::SYNC_RESOURCE_CREATE;
				tb->mModResource	= true;
				tb->mHasBody		= true;
			} else if( strcmp(tb->mJsMode->vString, "update_resource") == 0 ) {
				tb->mMode			= TBUpSync::SYNC_RESOURCE_UPDATEBODY;
				tb->mModResource	= true;
				tb->mExtResource	= true;
				tb->mHasBody		= true;
			} else if( strcmp(tb->mJsMode->vString, "update_resurcetag") == 0 ) {
				tb->mMode			= TBUpSync::SYNC_RESOURCE_UPDATETAG;
				tb->mModResource	= true;
				tb->mExtResource	= true;
				tb->mHasTag			= true;
			} else if( strcmp(tb->mJsMode->vString, "remove_resource") == 0 ) {
				tb->mMode			= TBUpSync::SYNC_RESOURCE_REMOVE;
				tb->mModResource	= true;
				tb->mExtResource	= true;

			} else if( strcmp(tb->mJsMode->vString, "create_gadget") == 0 ) {
				tb->mMode			= TBUpSync::SYNC_GADGET_CREATE;
				tb->mExtResource	= true;
				tb->mHasBody		= true;
			} else if( strcmp(tb->mJsMode->vString, "update_gadget") == 0 ) {
				tb->mMode			= TBUpSync::SYNC_GADGET_UPDATEBODY;
				tb->mExtResource	= true;
				tb->mExtGadget		= true;
				tb->mHasBody		= true;
			} else if( strcmp(tb->mJsMode->vString, "update_gadgettag") == 0 ) {
				tb->mMode			= TBUpSync::SYNC_GADGET_UPDATETAG;
				tb->mExtResource	= true;
				tb->mExtGadget		= true;
				tb->mHasTag			= true;
			} else if( strcmp(tb->mJsMode->vString, "remove_gadget") == 0 ) {
				tb->mMode			= TBUpSync::SYNC_GADGET_REMOVE;
				tb->mExtResource	= true;
				tb->mExtGadget		= true;
			} else {
				return taskResponse(q, ErrorParameter, "%s. \"mode\" value.", codeToMessgae(ErrorParameter));
			}

			switch(tb->mMode) {
			case TBUpSync::SYNC_RESOURCE_CREATE:
				if( !tb->mJsRName || !tb->mJsSize || !tb->mJsDeviceRev || !tb->mJsDeviceTime ) {
					return taskResponse(q, ErrorParameter, "%s. resource create param.", codeToMessgae(ErrorParameter));
				}
				break;
			case TBUpSync::SYNC_RESOURCE_UPDATETAG:
				if( !tb->mJsMID || (!tb->mJsRID && !tb->mJsRName) || !tb->mJsTag || !tb->mJsDeviceRev || !tb->mJsDeviceTime ) {
					return taskResponse(q, ErrorParameter, "%s. resource tag update param.", codeToMessgae(ErrorParameter));
				}
				break;
			case TBUpSync::SYNC_RESOURCE_UPDATEBODY:
				if( !tb->mJsMID || (!tb->mJsRID && !tb->mJsRName) || !tb->mJsSize || !tb->mJsDeviceRev || !tb->mJsDeviceTime ) {
					return taskResponse(q, ErrorParameter, "%s. resource update param.", codeToMessgae(ErrorParameter));
				}
				break;
			case TBUpSync::SYNC_RESOURCE_REMOVE:
				if( !tb->mJsMID || (!tb->mJsRID && !tb->mJsRName) || !tb->mJsDeviceRev || !tb->mJsDeviceTime ) {
					return taskResponse(q, ErrorParameter, "%s. resource remove param.", codeToMessgae(ErrorParameter));
				}
				break;
			case TBUpSync::SYNC_GADGET_CREATE:
				if( !tb->mJsMID || (!tb->mJsRID && !tb->mJsRName) || !tb->mJsGName || !tb->mJsDeviceRev || !tb->mJsDeviceTime ) {
					return taskResponse(q, ErrorParameter, "%s. resource remove param.", codeToMessgae(ErrorParameter));
				}
				break;
			case TBUpSync::SYNC_GADGET_UPDATETAG:
				if( !tb->mJsMID || (!tb->mJsRID && !tb->mJsRName) || !tb->mJsGName || !tb->mJsTag || !tb->mJsDeviceRev || !tb->mJsDeviceTime ) {
					return taskResponse(q, ErrorParameter, "%s. resource remove param.", codeToMessgae(ErrorParameter));
				}
				break;
			case TBUpSync::SYNC_GADGET_UPDATEBODY:
				if( !tb->mJsMID || (!tb->mJsRID && !tb->mJsRName) || !tb->mJsGName || !tb->mJsSize || !tb->mJsDeviceRev || !tb->mJsDeviceTime ) {
					return taskResponse(q, ErrorParameter, "%s. resource remove param.", codeToMessgae(ErrorParameter));
				}
				break;
			case TBUpSync::SYNC_GADGET_REMOVE:
				if( !tb->mJsMID || (!tb->mJsRID && !tb->mJsRName) || !tb->mJsGName || !tb->mJsDeviceRev || !tb->mJsDeviceTime ) {
					return taskResponse(q, ErrorParameter, "%s. resource remove param.", codeToMessgae(ErrorParameter));
				}
				break;
			}
			if( tb->mHasBody ) {
				QueueCommRecvRaw *qn = new QueueCommRecvRaw(task, tb->mJsSize->vInt);
				return task->call(qn, step+1);
			}
		}
	case 1:
		{
			if( step == 1 ) {
				QnCommRecvResult *ret = (QnCommRecvResult*)q;
				ErrorCode code = ret->getResultCode();
				if( code != ErrorOk ) {
					return taskResponse(q, code, "%s. UploadData recive error.", ret->getMessagePtr() );
				}
				if( ret->mData->size() != (size_t)tb->mJsSize->vInt ) {
					return taskResponse(q, ErrorComm, "%s. UploadData size unmatch error. need=%ld recv=%ld",
							codeToMessgae(ErrorComm), tb->mJsSize->vInt, ret->mData->size());
				}
				tb->mData	= ret->mData;
				ret->mData	= NULL;
			}
			step	= 1;

			QueryKeyType sref;
			sref.mId	= tb->mJsSID ? tb->mJsSID->vString : NULL;
			sref.mName	= tb->mJsSName ? tb->mJsSName->vString : NULL;
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryService(&sref);
			return task->call(qn, step+1);
		}

	case 2:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "%s. ServiceInfo load failed.", res->getMessagePtr());
			}
			tb->mService	= (ResultService*)res->mResult;
			res->mResult	= NULL;

			if( tb->mExtResource ) {
				QueryKeyType mref;
				mref.mId	= tb->mJsMID->vString;
				mref.mName	= NULL;
				QnDBQuery *qn = new QnDBQuery(task);
				qn->queryShare(NULL, &mref);
				return task->call(qn, step+1);
			}
		}
	case 3:
		{
			if( step == 3 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode code	= res->getResultCode();
				if( code != ErrorOk ) {
					return taskResponse(q, code, "%s. DeviceShareInfo load failed.", res->getMessagePtr());
				}
				tb->mShare		= (ResultShare*)res->mResult;
				res->mResult	= NULL;
			}
			step	= 3;

			if( tb->mExtResource ) {
				QueryKeyType rref;
				rref.mId	= tb->mShare->mShare.resourceId;
				rref.mName	= NULL;
				QnDBQuery *qn = new QnDBQuery(task);
				qn->queryResource(NULL, &rref);
				return task->call(qn, step+1);
			}
		}
	case 4:
		{
			if( step == 4 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode code	= res->getResultCode();
				if( code != ErrorOk ) {
					return taskResponse(q, code, "%s. ResourceInfo load failed.", res->getMessagePtr());
				}
				tb->mResource	= (ResultResource*)res->mResult;
				res->mResult	= NULL;
			}

			step	= 4;

			QnHTTPRequest *qn = new QnHTTPRequest(task);
			const char *ref="";
			const char *opt="";

			qn->setPostParam("accountId", task->getAccountId());
			qn->setPostParam("userId", task->getUserId());
			qn->setPostParam("udid", task->getDeviceId());
			qn->setPostParam("date", tb->mJsDeviceTime->vString);
			StdBuffer dataSize;
			if( tb->mData ) {
				dataSize.addfmt("%ld", tb->mData->size());
			}

			switch( tb->mMode ) {
			case TBUpSync::SYNC_RESOURCE_CREATE:
				ref	= tb->mService->mService.refURL;
				opt	= "put_resource";
				qn->setPostParam("put_resource","create");
				qn->setPostParam("resourceName", tb->mResource->mResource.name);
				qn->setPostParam("tag", tb->mJsTag ? tb->mJsTag->vString : "");
				if( tb->mJsTag ) {
					qn->setPostParam("tag", tb->mJsTag->vString);
				}
				if( tb->mData ) {
					qn->setPostParam("dataSize", dataSize.getPtr());
					qn->setPostFile("data", tb->mData);
					tb->mData	= NULL;
				} else {
					qn->setPostParam("dataSize", "0");
				}
				break;

			case TBUpSync::SYNC_RESOURCE_REMOVE:
				ref	= tb->mResource->mResource.refURL;
				opt	= "put_resource";
				qn->setPostParam("put_resource","remove");
				qn->setPostParam("resourceId", tb->mResource->mResource.id);
				qn->setPostParam("resourceName", tb->mResource->mResource.name);
				qn->setPostParam("dataSize", "0");
				break;

			case TBUpSync::SYNC_RESOURCE_UPDATEBODY:
				ref	= tb->mResource->mResource.refURL;
				opt	= "put_resource";
				qn->setPostParam("put_resource","update");
				qn->setPostParam("resourceId", tb->mResource->mResource.id);
				qn->setPostParam("resourceName", tb->mResource->mResource.name);
				qn->setPostParam("tag", tb->mJsTag ? tb->mJsTag->vString : "");
				if( tb->mData ) {
					qn->setPostParam("dataSize", dataSize.getPtr());
					qn->setPostFile("data", tb->mData);
					tb->mData	= NULL;
				} else {
					qn->setPostParam("dataSize", "0");
				}
				break;

			case TBUpSync::SYNC_RESOURCE_UPDATETAG:
				ref	= tb->mResource->mResource.refURL;
				opt	= "put_resource";
				qn->setPostParam("put_resource","update");
				qn->setPostParam("resourceId", tb->mResource->mResource.id);
				qn->setPostParam("resourceName", tb->mResource->mResource.name);
				qn->setPostParam("tag", tb->mJsTag ? tb->mJsTag->vString : "");
				qn->setPostParam("dataSize", "0");
				break;

			case TBUpSync::SYNC_GADGET_CREATE:
				ref	= tb->mResource->mResource.refURL;
				opt	= "put_gadget";
				qn->setPostParam("put_gadget","create");
				qn->setPostParam("resourceId", tb->mResource->mResource.id);
				qn->setPostParam("resourceName", tb->mResource->mResource.name);
				qn->setPostParam("gadgetName", tb->mJsGName->vString);
				qn->setPostParam("tag", tb->mJsTag ? tb->mJsTag->vString : "");
				if( tb->mData ) {
					qn->setPostParam("dataSize", dataSize.getPtr());
					qn->setPostFile("data", tb->mData);
					tb->mData	= NULL;
				} else {
					qn->setPostParam("dataSize", "0");
				}
				break;

			case TBUpSync::SYNC_GADGET_REMOVE:
				ref	= tb->mResource->mResource.refURL;
				opt	= "put_gadget";
				qn->setPostParam("put_gadget","remove");
				qn->setPostParam("resourceId", tb->mResource->mResource.id);
				qn->setPostParam("resourceName", tb->mResource->mResource.name);
				qn->setPostParam("gadgetName", tb->mJsGName->vString);
				qn->setPostParam("dataSize", "0");
				break;

			case TBUpSync::SYNC_GADGET_UPDATEBODY:
				ref	= tb->mResource->mResource.refURL;
				opt	= "put_gadget";
				qn->setPostParam("put_gadget","update");
				qn->setPostParam("resourceId", tb->mResource->mResource.id);
				qn->setPostParam("resourceName", tb->mResource->mResource.name);
				qn->setPostParam("gadgetName", tb->mJsGName->vString);
				qn->setPostParam("tag", tb->mJsTag ? tb->mJsTag->vString : "");
				if( tb->mData ) {
					qn->setPostParam("dataSize", dataSize.getPtr());
					qn->setPostFile("data", tb->mData);
					tb->mData	= NULL;
				} else {
					qn->setPostParam("dataSize", "0");
				}
				break;

			case TBUpSync::SYNC_GADGET_UPDATETAG:
				ref	= tb->mResource->mResource.refURL;
				opt	= "put_gadget";
				qn->setPostParam("put_gadget","update");
				qn->setPostParam("resourceId", tb->mResource->mResource.id);
				qn->setPostParam("resourceName", tb->mResource->mResource.name);
				qn->setPostParam("gadgetName", tb->mJsGName->vString);
				qn->setPostParam("tag", tb->mJsTag ? tb->mJsTag->vString : "");
				qn->setPostParam("dataSize", "0");
				break;
			}

			StdBuffer url;
			const char *p = ref;
			while( *p ) {
				if( *p == '?' ) break;
				p++;
			}
			if( *p == '?' ) {
				url.addfmt("%s&opt=%s", ref, opt);
			} else {
				url.addfmt("%s%s", ref, opt);
			}
			qn->setPostRequest(url.getPtr());
			return task->call(qn, step+1);
		}
	case 5:
		{
			QnHTTPResult *res	= (QnHTTPResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk || res->mStatusCode != 200 ) {
				if( code == 0 ) {
					code = ErrorHTTP;
				}
				return taskResponse(q, code, "%s HTTP Upload error. statusCode=%d.",
						codeToMessgae(code),
						res->mStatusCode);
			}
			// TODO: update resource info (revision)
			// TODO: update device share info (revision)
			// TODO: sync
		}
	case 99:
		{
			QnResult *r = new QnResult(task);
			r->setResult(q->getFunction(),ErrorOk);
			return task->endTask(r);
		}
	}
	taskLog(q, LOG_ERR, "unknown step=%d.", step);
	return false;

}


}
