/*
 * sentinel.h
 *
 *  Created on: 2012/06/05
 *      Author: Yasuoki
 */

#ifndef SENTINEL_H_
#define SENTINEL_H_

#include "../include/sst_types.h"
#include "device_slot.h"
#include "session.h"
#include "proc_listener.h"
#include "proc_requester.h"
#include "proc_command.h"
#include "proc_database.h"
#include "scheduler.h"
#include "task.h"
#include <csignal>
#include <syslog.h>
#include <event2/event.h>
#include <event2/thread.h>

namespace SST {

const char *codeToMessgae(ErrorCode code);

class Sentinel {
public:
	Sentinel();
	~Sentinel();
private:
	Sentinel(const Sentinel &c);
	Sentinel &operator=(const Sentinel &c);
public:
	void	log(int logLevel, const char *fmt, ...);
	void	logv(int logLevel, const char *fmt, va_list ap);
	bool 	loadConfig(const char *file);
	Conf *	getConf();
	bool	run();
	bool	process();
	bool	waitDataArive(Session *c);

	SessionPool &getSessionPool();
	Scheduler &getScheduler() { return mScheduler; }
	CommandProc &	getCommand() { return mCommand; }
	Listener &	getListener()  { return mListener; }
	Database &	getDatabase()  { return mDatabase; }
	Requester&	getRequester() { return mRequester; }
	TaskManager & getTaskManager() { return mTaskManager; }

	int		getLoad() const;
	Task *	createTask();
	bool	beginTask(Task *t);
	void	endTask(Task *t);

protected:
	Conf *	allocConf(const char *confFileName);
	void	freeConf(Conf *conf);
	bool	configure();
	bool	startThreads();
	void	waitThreads();
	bool	checkDatabase();
	static void	sigtermProc(int fd, short event, void *args);
	static void	sighupProc(int fd, short event, void *args);
	static void	sigintProc(int fd, short event, void *args);

	Conf *				mConf;

	// threads
	Scheduler			mScheduler;

	// processes
	CommandProc			mCommand;
	Listener			mListener;
	Database 			mDatabase;
	Requester			mRequester;

	TaskManager			mTaskManager;

	DeviceSlotList 		mDevices;
	SessionPool			mSessions;

	pthread_mutex_t		mLogMutex;
	struct event_base *eventBase;
    struct event *sigterm;
    struct event *sighup;
    struct event *sigint;
};

}

#endif /* SENTINEL_H_ */
