#ifndef SENTINEL_PORT_H_INCLUDE
#define SENTINEL_PORT_H_INCLUDE

#ifdef  __cplusplus
extern "C" {
#endif

#define SST_LINUX

/* ---------------------- Microsoft Windows ---------------------- */
#if defined(WIN32)
#	undef SST_LINUX
#	define SST_WINDOWS
#endif

#if defined(SST_WINDOWS)
# define SST_EXPORT extern __declspec(dllexport)
# define SST_IMPORT extern __declspec(dllimport)
# define SST_GLOBAL
#else
# define SST_EXPORT extern
# define SST_IMPORT extern
# define SST_GLOBAL
#endif

#ifdef SST_PORT_EXPORTS
#define SST_PORT_API SST_EXPORT
#else
#define SST_PORT_API SST_IMPORT
#endif

#define SST_E_OK				0
#define SST_E_PARAMRAGE			1
#define SST_E_PARAMVALUE		2
#define SST_E_NOTIMPL			3
#define SST_E_IOERROR			4
#define SST_E_MEMORY			5
#define SST_E_PERMISSION		6
#define SST_E_NOTFOUND			7
#define SST_E_STREAM			8
#define SST_E_DUPLICATE			9
#define SST_E_EXISTS			10
#define SST_E_NOTEXISTS			11
#define SST_E_DATAINVALID		12
#define SST_E_VERSION			13
#define SST_E_NOTSPACE			14
#define SST_E_INCONSISTENT		15
#define SST_E_NOTFS				16
#define SST_E_BADFS				17
#define SST_E_DUPLICATEOPEN		18
#define SST_E_AUTHORIZATION		19
#define SST_E_NOTTAG			20
#define SST_E_TOOMANYOPEN		21
#define SST_E_TOOMANYCONNECT	22
#define SST_E_BUSY				23

typedef struct _SSTConn SSTConn;
typedef struct _SSTStream SSTStream;
SST_PORT_API int SST_Connect(SSTConn **conn, char *addr, int port, char * app, char *user, char *pass);
SST_PORT_API int SST_Send(SSTConn *conn, char *cmd, int len, SSTStream **ans);
SST_PORT_API int SST_ReadStream(SSTStream *st, char *buffer, unsigned int size, unsigned int *readed);
SST_PORT_API int SST_CloseStream(SSTStream *st);
SST_PORT_API int SST_Disconnect(SSTConn *conn);

#ifdef  __cplusplus
}
#endif
#endif /* SENTINEL_PORT_H_INCLUDE */
