/*
 * message.cpp
 *
 *  Created on: 2012/07/31
 *      Author: tanaka
 */

#include "../include/sst_types.h"
#include "message.h"
#include <unistd.h>
#include <string.h>
#include <malloc.h>

namespace SST {

Message::Message()
{
	pURL		= NULL;
	pScheme		= NULL;
	status		= 0;
	bHeader		= 0;
	nHeader		= 0;
	pHeader		= NULL;
	bParam		= 0;
	nParam		= 0;
	pParam		= NULL;
}
Message::~Message()
{
	clear();
}

void Message::clear()
{
	if( pHeader ) free(pHeader);
	if( pParam ) free(pParam);
	pURL		= NULL;
	pScheme		= NULL;
	status		= 0;
	bHeader		= 0;
	nHeader		= 0;
	pHeader		= NULL;
	bParam		= 0;
	nParam		= 0;
	pParam		= NULL;
	values.clear();
	content.clear();
}

bool Message::setURL(const char *url)
{
	size_t len = strlen(url);
	pURL	= values.store(url, len+1);
	if( !pURL ) return false;
	return true;
}

bool Message::addHeader(const char *name, const char *value)
{
	if( nHeader+1 >= bHeader ) {
		size_t bNew = bHeader + 8;
		NamedValue *pNew = (NamedValue*)realloc(pHeader, sizeof(NamedValue)*bNew);
		if( !pNew ) return false;
		pHeader	= pNew;
		bHeader	= bNew;
	}
	pHeader[nHeader].name	= (char*)values.store(name, strlen(name)+1);
	if( pHeader[nHeader].name == NULL ) return false;
	pHeader[nHeader].value	= (char*)values.store(value, strlen(value)+1);
	if( pHeader[nHeader].value == NULL ) return false;
	nHeader++;
	return true;
}

bool Message::setHeader(const char *name, const char *value)
{
	size_t i;
	for( i = 0; i < nHeader; i++ ) {
		if( strcmp(pHeader[i].name, name) == 0 ) {
			const char *nv = values.store(value, strlen(value)+1);
			if( !nv ) return false;
			pHeader[i].value = (char*)nv;
			return true;
		}
	}
	return addHeader(name, value);
}

size_t Message::getHeaderCount()
{
	return nHeader;
}

const NamedValue * Message::getHeader(size_t index)
{
	return &pHeader[index];
}

const char * Message::getHeaderValue(const char *name)
{
	size_t i;
	for( i = 0; i < nHeader; i++ ) {
		if( strcmp(pHeader[i].name, name) == 0 ) {
			return pHeader[i].value;
		}
	}
	return NULL;
}

bool Message::addParam(const char *name, const char *value)
{
	if( nParam+1 >= bParam ) {
		size_t bNew = bParam + 8;
		NamedValue *pNew = (NamedValue*)realloc(pParam, sizeof(NamedValue)*bNew);
		if( !pNew ) return false;
		pParam	= pNew;
		bParam	= bNew;
	}
	pParam[nParam].name		= (char*)values.store(name, strlen(name)+1);
	if( pParam[nParam].name == NULL ) return false;
	pParam[nParam].value	= (char*)values.store(value, strlen(value)+1);
	if( pParam[nParam].value == NULL ) return false;
	nParam++;
	return true;
}

size_t Message::getParamCount()
{
	return nParam;
}

const NamedValue * Message::getParam(size_t index)
{
	return &pParam[index];
}

const char * Message::getParamValue(const char *name)
{
	size_t i;
	for( i = 0; i < nParam; i++ ) {
		if( strcmp(pParam[i].name, name) == 0 ) {
			return pParam[i].value;
		}
	}
	return NULL;
}

bool Message::addContent(const char *ptr, size_t size)
{
	return content.add(ptr, size);
}


size_t Message::getContentSize()
{
	return content.size();
}

const char * Message::getContent()
{
	return content.getPtr();
}

}


