/*
 * process.h
 *
 *  Created on: 2012/12/08
 *      Author: yasuoki
 */

#ifndef PROCESS_H_
#define PROCESS_H_

#include "../include/sst_types.h"
#include "queue.h"
#include <time.h>

namespace SST {

#ifdef _DEBUG_PROC_TRACE
# define PROC_BEGIN(PROC,T,Q) \
	mSentinel->log(LOG_DEBUG, "%s::" PROC ": begin. task=%x q=%x", getName(), (T), (Q));
# define PROC_END(PROC,T,Q) \
	mSentinel->log(LOG_DEBUG, "%s::" PROC ": end. task=%x q=%x", getName(), (T), (Q));
#else
# define PROC_BEGIN(PROC,T,Q)
# define PROC_END(PROC,T,Q)
#endif

class Process {
public:
	Process();
	virtual ~Process();

	virtual bool	configure(Sentinel *obj, Conf *conf);
	virtual void	clear();
	virtual const char *getName() const { return "unokown"; }
	virtual const char *getFuncName(int id) { return "unknown"; }

	virtual bool	taskResponse(QueueNode *q, ErrorCode code, const char *fmt, ...);
	virtual bool	taskResponseLog(int logLevel, QueueNode *q, ErrorCode code, const char *fmt, ...);
	virtual bool	taskResponseLogVa(int logLevel, QueueNode *q, ErrorCode code, const char *fmt, va_list ap);
	virtual void	taskLog(QueueNode *q, int logLevel, const char *fmt, ...);

	int		getMaxThread() const;
	int		getMinThread() const;
	int		getRunThread() const;
	bool	reserveThread();
	void	cancelThread();
	bool	queuIsEmpty() const;
	unsigned long long getWaitTime() const;

	QueueNode *		nextQueue();
	QueueNode *		getQueue();
	bool 			putQueue(QueueNode *q);
	bool			doProcess(QueueNode *q);
	void			doAbort();
	virtual bool	diag(pjson::builder &jb);

protected:
	virtual bool	exec(QueueNode *q);
	virtual void	stop(QueueNode *q);

	Sentinel *	mSentinel;
	int			mMaxThread;
	int			mMinThread;
	int			mRunThread;
	int			mReserveThread;
	Queue		mQueue;
	size_t		mPutQueue;
	size_t		mGetQueue;
};

}

#endif /* PROCESS_H_ */
