/*
 * staticBuffer.h
 *
 *  Created on: 2012/12/08
 *      Author: yasuoki
 */

#ifndef STATICBUFFER_H_
#define STATICBUFFER_H_


#include "../include/sst_types.h"
#include "buffer.h"

namespace SST {

class StaticBuffer : public Buffer{
public:
	StaticBuffer();
	~StaticBuffer();
private:
	StaticBuffer(const StaticBuffer &c);
	StaticBuffer &operator=(const StaticBuffer &c);
public:
	bool	add(const char *data, ssize_t size);
	size_t	size() const;
	size_t	get(char *buff, size_t buffSize);
	size_t	getLine(char *buff, size_t buffSize);
	size_t	getAt(char *buff, size_t start, size_t len) const;
	const char *getPtr() const;
	void	clear();
	bool	empty() const;

	const char *store(const char *data, size_t size);
	const char *storePtr() const;

protected:
	StaticBuffer * next;
	size_t	nAlloc;
	size_t	nUse;
	char *	ptr;
	char *	prevStore;
};

}


#endif /* STATICBUFFER_H_ */
