/*
 * sst_types.h
 *
 *  Created on: 2012/06/05
 *      Author: yasuoki
 */

#ifndef SST_TYPES_H_
#define SST_TYPES_H_

#include <stdlib.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define SST_VERSION			"1.0.0"
#define SST_SYSLOGIDENT		"sentinel"
#define SST_STDERRIDENT		"stderr"
#define SST_CONFFOLDER		"/etc/sentinel"
#define SST_CONFFILE		"sentinel.conf"
#define SST_PIDFILE			"/var/run/sentinel.pid"
#define SST_NODENAME_LEN	32
#define SST_PORT			1119
#define SST_TIMEOUT			30
#define SST_MAXWAITTIME		600
#define SST_SYNCWAITTIME	5
#define SST_HEARTBEETINTERVAL (15*60)
#define SST_CONNTHREADS 	4
#define SST_DBTHREADS		4
#define SST_ACCOUNTID_LEN	32	// Annnnnnnn
#define SST_USERID_LEN		256
#define SST_DEVICEID_LEN	32	// Dnnnnnnnn
#define SST_SERVICEID_LEN	32	// Snn
#define	SST_SERVICENAME_LEN	256
#define SST_GROUPID_LEN		32	// GSnnnnn:nnnnnnnn
#define SST_RESOURCEID_LEN	32	// Rnnnnnnnn
#define SST_SHAREID_LEN		32	// Rnnnnnnnn
#define	SST_SESSIONID_LEN	32	// Cnnnnnnnn
#define	SST_ADDR_LEN		32	// nnn.nnn.nnn.nnn:nnnnn

#define SST_IOBUFFER_BLOCKSIZE	64
#define SST_ERR_NOMORECONNECTION 500

#define SST_MINIMUM_BLOCKSIZE	1024
#define SST_MAXIMUM_BLOCKSIZE	4096
#define SST_DEFAULT_BLOCKSIZE	2048
#define SST_MINIMUM_BLOCKCOUNT	64
#define SST_MAXIMUM_BLOCKCOUNT	32768
#define SST_DEFAULT_BLOCKCOUNT	32768

namespace SST {

class LockObject;
class LockBase;
class ReadLock;
class WriteLock;
class CyclicBuffer;
class StaticBuffer;
class StdBuffer;
class Link;
class Session;
class SessionPool;
class DeviceSlot;
class DeviceSlotList;
class Group;
class GroupList;
class Service;
class Schedule;
class Resource;
class Queue;
class QueueNode;
class Task;
class TaskManager;
class TaskBuffer;

class Scheduler;
class Process;
class Database;
class CommandProc;
class Listener;
class Requester;
class DBPort;

class Message;
class RequestNode;
class Sentinel;

typedef unsigned long long revision_t;

enum LogLevel {
	LogLevelDebug = 0,
	LogLevelVerbose = 1,
	LogLevelNotice = 2,
	LogLevelWarning = 3,
	LogLevelError = 4,
};

enum DeviceSlotStatus {
	DeviceSlotFree		= 0,
	DeviceSlotAssign	= 1,
	DeviceSlotAuth		= 3,
	DeviceSlotLinked	= 4,
	DeviceSlotWait		= 5,
	DeviceSlotClose		= 6,
};

enum LinkSpeed {
	LinkNone 		= 0,
	LinkHighSpeed	= 1,
	LinkLowSpeed	= 2,
};

enum ScheduleType {
	ScheduleNone		= 0,
	ScheduleEveryTime	= 1,
	ScheduleEveryDay	= 2,
	ScheduleEveryWeek	= 3,
	ScheduleEveryMonth	= 4,
	ScheduleSpecifyTime	= 5,
};

enum SessionStatus {
	SessionStatusWait		= 0,
	SessionStatusAccept		= 1,
	SessionStatusConnect	= 2,
	SessionStatusLogin		= 3,
};

// TODO: permission check
enum AccountLevel {
	AccountUser				= 0,
	AccountServiceAdmin		= 1,
	AccountSystemAdmin		= 2,
	AccountSystemService	= 3
};

enum AccountStatus {
	AccountNormal			= 0,
	AccountStop				= 1,
};

enum AuthType {
	AuthNone		= 0,
	AuthUser		= 1,
	AuthPasswd		= 2,
	AuthExternURL	= 3
};

enum ServiceScope {
	ScopePublic		= 0,
	ScopePrivate	= 1,
};

enum CryptAlgorithm {
	CryptAlgorithmNone	= 0,
	CryptAlgorithm3DES	= 1,
	CryptAlgorithmAES192= 2,
};

enum ServiceStatus {
	ServiceStop = 0,
	ServiceOpen = 1,
	ServiceClose = 2,
	ServiceError = 3,
};

enum ResourceStatus {
	ResourceStop = 0,
	ResourceOpen = 1,
	ResourceClose = 2,
	ResourceError = 3,
};

enum DeviceStatus {
	DeviceNull	 	= 0,
	DeviceConnect 	= 1,
	DeviceLogin		= 2,
	DeviceStop		= 3,
};

enum GroupStatus {
	GroupNormal	= 0,
	GroupStop	= 1,
};

enum TaskStatus {
	TaskInit			= 0,
	TaskIdle			= 1,
	TaskActive			= 2,
	TaskProcess			= 3,
};

enum ShareDataMode {
	ShareDataIndex		= 0,
	ShareDataFull		= 1,
};

enum ShareAccessMode {
	ShareAccessRead		= 0,
	ShareAccessWrite	= 1,
	ShareAccessGadget	= 2,
	ShareAccessTag		= 4,
};

enum DeviceShareStatus {
	DeviceShareNone			= 0,
	DeviceShareProgress		= 1,
	DeviceShareComprete		= 2,
	DeviceShareNeedRefresh	= 2,
};

enum ErrorCode {
	ErrorOk				= 0,
	ErrorNoMemory		= 1,
	ErrorRuntime		= 2,
	ErrorConnection		= 3,
	ErrorDatabase		= 4,
	ErrorComm			= 5,
	ErrorMessage		= 6,
	ErrorCommand		= 7,
	ErrorNotLogin		= 8,
	ErrorPermission		= 9,
	ErrorNotFound		= 10,
	ErrorDataFull		= 11,
	ErrorDataLost		= 12,
	ErrorDataConflict	= 13,
	ErrorParameter		= 14,
	ErrorHierarchy		= 15,
	ErrorDuplicate		= 16,
	ErrorAuth			= 17,
	ErrorHTTP			= 18,
	ErrorSystem			= 19,
	ErrorLocked			= 20,
	ErrorUser			= 21,
	ErrorNoSpace		= 22,
	ErrorDataType		= 23,
	ErrorData			= 24,
	ErrorNotImpl		= 25,
	ErrorNotEmpty		= 26,
	ErrorRestriction	= 27,
};

enum AccountField {
	AccountName		= 0x01,
	AccountAuth		= 0x02,
	AccountMail		= 0x04,
	AccountStat		= 0x08,
	AccountAll		= 0xff,
};

typedef struct _QueryKeyType {
	const char *	mName;
	const char *	mId;
} QueryKeyType;

typedef struct _QueryBase {
	QueryKeyType	mSREF;
} QueryBase;

typedef struct _QueryKey1 {
	QueryKeyType	mSREF;
	QueryKeyType	mKey1;
} QueryKey1;

typedef struct _QueryKey2 {
	QueryKeyType	mSREF;
	QueryKeyType	mKey1;
	QueryKeyType	mKey2;
} QueryKey2;

typedef struct _QueryKey3 {
	QueryKeyType	mSREF;
	QueryKeyType	mKey1;
	QueryKeyType	mKey2;
	QueryKeyType	mKey3;
} QueryKey3;

typedef struct _QueryRangeType {
	int				mStart;
	int				mCount;
} QueryRangeType;

typedef struct _QueryRange {
	QueryKeyType	mSREF;
	QueryRangeType	mRange;
} QueryRange;

typedef struct _QueryKey1Range {
	QueryKeyType	mSREF;
	QueryKeyType	mKey1;
	QueryRangeType	mRange;
} QueryKey1Range;

typedef struct _QueryKey2Range {
	QueryKeyType	mSREF;
	QueryKeyType	mKey1;
	QueryKeyType	mKey2;
	QueryRangeType	mRange;
} QueryKey2Range;

typedef struct _QueryKey1Index {
	QueryKeyType	mSREF;
	QueryKeyType	mKey1;
	size_t			mIndex;
} QueryKey1Index;

typedef struct _QueryKey3Range {
	QueryKeyType	mSREF;
	QueryKeyType	mKey1;
	QueryKeyType	mKey2;
	QueryKeyType	mKey3;
	QueryRangeType	mRange;
} QueryKey3Range;

typedef struct _RecList {
	size_t	size;
	size_t	count;
	size_t	values;
	char *	value[1];
} RecList;

typedef struct _Account {
	char *			id;
	char *			uid;
	char *			name1;
	char *			name2;
	char *			locale;
	AuthType		authType;
	char *			authData;
	AccountStatus	status;
	AccountLevel	level;
	int				maxStorage;
	int				useStorage;
	time_t			createTime;
	time_t			updateTime;
	time_t			loginTime;
} Account;

typedef struct _DeviceInfo {
	char *			id;
	char *			udid;
	char *			OS;
	char *			OSVersion;
	char *			carrier;
	char *			model;
	char *			signature;
	char *			accountId;
	CryptAlgorithm	storageCrypt;
	size_t			storageBlockSize;
	size_t			storageBlockCount;
	size_t			storageUse;
	DeviceStatus	status;
	time_t			loginTime;
	time_t			createTime;
	time_t			updateTime;
} DeviceInfo;

typedef struct _ServiceInfo {
	char *			id;
	char *			name;
	char *			title;
	char *			desc;
	char *			version;
	char *			adminId;
	char *			refURL;
	ServiceScope	scope;
	char *			defaultGroup;
	size_t			storageBlockSize;
	size_t			storageBlockCount;
	CryptAlgorithm	storageCrypt;
	AuthType		authType;
	char *			authData;
	ServiceStatus	status;
	time_t			createTime;
	time_t			updateTime;
} ServiceInfo;

typedef struct _GroupInfo {
	char *			id;
	char *			name;
	char *			serviceId;
	GroupStatus		status;
	char *			adminId;
	char *			description;
	time_t			createTime;
	time_t			updateTime;
} GroupInfo;

typedef struct _AuthParam {
	char *	id;
	char *	password;
	char *	response;
	char *	nonce;
	char *	cnonce;
	char *	algorithm;
} AuthParam;

typedef struct _GadgetInfo {
	char *			id;
	char *			name;
	char *			tag;
	time_t			refTime;
	revision_t		revision;
	ResourceStatus	status;
} GadgetInfo;

typedef struct _ResourceInfo {
	char *			id;
	char *			name;
	char *			tag;
	char *			serviceId;
	char *			refURL;
	time_t			refTime;
	revision_t		revision;
	ResourceStatus	status;
	size_t			shareCount;
	size_t			gadgetCount;
	GadgetInfo 	*	gadgetArray;
	time_t			createTime;
	time_t			updateTime;
} ResourceInfo;

typedef struct _GeoLocation {
	double		dis;
	double		lat;
	double		lon;
} GeoLocation;

typedef struct _ShareInfo {
	char *			id;
	char *			resourceId;
	size_t			index;
	char *			serviceId;
	ShareDataMode	dataMode;
	ShareAccessMode	accessMode;
	time_t			expireTime;
	time_t			fromTime;
	time_t			endTime;
	size_t			geoLocationCount;
	GeoLocation		geoLocation[2];
	int				gpsGrace;
	int				offlineGrace;
	size_t			groupCount;
	QueryKeyType *	groupArray;
	time_t			createTime;
} ShareInfo;

typedef struct _DeviceShareInfo {
	char *				serviceId;
	char *				shareId;
	char *				deviceId;
	char *				accountId;
	time_t				deviceTime;
	revision_t			deviceRevision;
	DeviceShareStatus	status;
	time_t				shareTime;
} DeviceShareInfo;

typedef struct _SessionInfo {
	char *			id;
	char *		 	servName;
	sockaddr_in 	peerAddr;
	char *			serviceId;
	char *			accountId;
	char *			deviceId;
	SessionStatus	status;
	time_t			createTime;
	time_t			updateTime;
} SessionInfo;

typedef struct _NodeInfo {
	sockaddr_in 	addr;
	char *			name;
	time_t			time;
	int				load;
} NodeInfo;

typedef struct _Conf {
	char *	confFile;
	char *	pidFile;
	bool	daemonaize;
	LogLevel	logLevel;
	char *	logIdent;
	int		numThreads;

	int		maxDeviceProcess;
	int		minDeviceProcess;
	int		maxDevices;
	int		maxConnections;
	char *	serverName;
	int		port;
	char *	bind;
	char *	authPasswd;
	char *	authMethod;
	int		timeout;
	int		maxWaitTime;
	int		syncQueueWaitTime;
	int		heartBeetInterval;

	int		maxCommandProcess;
	int		minCommandProcess;

	int		maxHTTPProcess;
	int		minHTTPProcess;
	int		httpBufferSize;

	int		maxDBProcess;
	int		minDBProcess;
	char *	dbServer;
	int		dbPort;
	char *	dbAuth;
	char *	adminId;
	char *	adminPass;

	char *	masterServer;
	int		masterPort;
	char *	masterAuth;
	bool	cloneMaster;
} Conf;


typedef struct _RegistBase {
	QueryKeyType	mSREF;
} RegistBase;

typedef struct _RegistAccount {
	QueryKeyType	mSREF;
	Account			mAccount;
} RegistAccount;

typedef struct _RegistDevice {
	QueryKeyType	mSREF;
	DeviceInfo		mDevice;
} RegistDevice;

typedef struct _RegistDeviceShare {
	QueryKeyType	mDREF;
	QueryKeyType	mMREF;
} RegistDeviceShare;

typedef struct _RegistService {
	QueryKeyType	mSREF;
	ServiceInfo		mService;
} RegistService;

typedef struct _RegistResource {
	QueryKeyType	mSREF;
	ResourceInfo	mResource;
} RegistResource;

typedef struct _RegistShare {
	QueryKeyType	mSREF;
	QueryKeyType	mRREF;
	ShareInfo		mShare;
} RegistShare;

typedef struct _RegistGroup {
	QueryKeyType	mSREF;
	GroupInfo		mGroup;
} RegistGroup;

typedef struct _RegistGroupAccount {
	QueryKeyType	mSREF;
	QueryKeyType	mGroup;
	QueryKeyType	mAccount;
} RegistGroupAccount;

typedef struct _RegistSession {
	QueryKeyType	mSREF;
	SessionInfo		mSession;
} RegistSession;

typedef struct _RegistNode {
	QueryKeyType	mSREF;
	NodeInfo		mNode;
} RegistNode;

typedef struct _RegistList {
	QueryKeyType	mSREF;
	RecList			mList;
} RegistList;

enum SyncQueueCmd {
	SyncCMDUpdate	= 1,
	SyncCMDRemove	= 2,
};
typedef struct _RegistSyncQueue {
	SyncQueueCmd	mCmd;
	QueryKeyType	mSREF;
	QueryKeyType	mAREF;
	size_t			mGREFCount;
	QueryKeyType *	mGREFArr;
} RegistSyncQueue;

typedef struct _ResultBase {
} ResultBase;

typedef struct _ResultId {
	ResultBase		mBase;
	char *			mId;
} ResultId;

typedef struct _ResultCount {
	ResultBase		mBase;
	long long int	mCount;
} ResultCount;

typedef struct _ResultAccount {
	ResultBase		mBase;
	Account			mAccount;
} ResultAccount;

typedef struct _ResultDevice {
	ResultBase		mBase;
	DeviceInfo			mDevice;
} ResultDevice;

typedef struct _ResultService {
	ResultBase		mBase;
	ServiceInfo		mService;
} ResultService;

typedef struct _ResultResource {
	ResultBase		mBase;
	ResourceInfo	mResource;
} ResultResource;

typedef struct _ResultGroup {
	ResultBase		mBase;
	GroupInfo		mGroup;
} ResultGroup;

typedef struct _ResultShare {
	ResultBase		mBase;
	ShareInfo		mShare;
} ResultShare;

typedef struct _ResultSession {
	ResultBase		mBase;
	SessionInfo		mSession;
} ResultSession;

typedef struct _ResultNode {
	ResultBase		mBase;
	NodeInfo		mNode;
} ResultNode;

typedef struct _ResultList {
	ResultBase		mBase;
	RecList			mList;
} ResultList;
typedef struct _NamedValue {
	char *name;
	char *value;
} NamedValue;

}

#endif /* SST_TYPES_H_ */
