/*
 * buffer.h
 *
 *  Created on: 2012/07/05
 *      Author: yasuoki
 */

#ifndef BUFFER_H_
#define BUFFER_H_

#include "../include/sst_types.h"
#include <stdarg.h>

namespace SST {

class Buffer {
public:
	Buffer() {}
	virtual ~Buffer() {}
private:
	Buffer(const Buffer &c);
	Buffer &operator=(const Buffer &c);
public:
	virtual bool	add(const char *data, ssize_t size) = 0;
	virtual bool	addfmt(const char *fmt, ...);
	virtual bool	addvafmt(const char *fmt, va_list ap);
	virtual size_t	size() const = 0;
	virtual size_t	get(char *buff, size_t buffSize) = 0;
	virtual size_t	getLine(char *buff, size_t buffSize) = 0;
	virtual size_t	getAt(char *buff, size_t start, size_t len) const = 0;
	virtual const char *getPtr() const = 0;
	virtual size_t	seek(size_t size);
	virtual void	clear() = 0;
	virtual bool	empty() const = 0;
};

}

#endif /* BUFFER_H_ */
