/*
 * cmd_resource.cpp
 *
 *  Created on: 2013/01/29
 *      Author: yasuoki
 */
#include "commands.h"
#include "proc_command.h"
#include "proc_database.h"
#include "proc_requester.h"
#include "task.h"
#include "sentinel.h"
#include "buffer.h"
#include "pjson.h"
#include <syslog.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

namespace SST {

bool CommandProc::cmdRmResource(QueueNode *q)
{
	return taskResponse(q, ErrorNotImpl, "%s.", codeToMessgae(ErrorNotImpl));
}

class TBLsResource: public TaskBuffer {
public:
	TBLsResource() {
		mJsCommand	= NULL;
		mJsSID		= NULL;
		mJsSName	= NULL;
		mJsFrom		= NULL;
		mJsCount	= NULL;
		mList		= NULL;
		mIndex		= 0;
		mCount		= 0;
	}
	virtual ~TBLsResource() {
		if( mJsCommand )	delete mJsCommand;
		if( mList )			free(mList);
	}
	pjson::json *	mJsCommand;
	pjson::value *	mJsSID;
	pjson::value *	mJsSName;
	pjson::value *	mJsFrom;
	pjson::value *	mJsCount;
	ResultList *	mList;
	size_t			mIndex;
	size_t			mCount;
	pjson::builder	mJb;
};

bool CommandProc::cmdLsResource(QueueNode *q)
{
	Task *task = q->getTask();
	int step = q->getStep();

	TBLsResource *tb = (TBLsResource *)task->getTaskBuffer();
	if( tb == NULL ) {
		tb = new TBLsResource();
		if( tb == NULL ) {
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
		if( !task->setTaskBuffer(tb) ) {
			delete tb;
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
 	}

	switch(step) {
	case 0:
		{
			tb->mJsCommand	= q->detouchJSONMessage();

			pjson::value *vCmd = tb->mJsCommand->get("lsResource");
			if( vCmd ) {
				tb->mJsSID		= tb->mJsCommand->get("sid", vCmd);
				tb->mJsSName	= tb->mJsCommand->get("serviceName", vCmd);
				tb->mJsFrom		= tb->mJsCommand->get("from",  vCmd);
				tb->mJsCount	= tb->mJsCommand->get("count", vCmd);
				if( tb->mJsSID && tb->mJsSID->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"sid\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsSName && tb->mJsSName->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"serviceName\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsFrom && tb->mJsFrom->vt != pjson::vt_int ) {
					return taskResponse(q, ErrorParameter, "%s. \"from\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsCount && tb->mJsCount->vt != pjson::vt_int ) {
					return taskResponse(q, ErrorParameter, "%s. \"count\" type.", codeToMessgae(ErrorParameter));
				}
			}
			QueryKeyType sref;
			QueryRangeType range;

			sref.mId	= (char*)(tb->mJsSID ? tb->mJsSID->vString : NULL);
			sref.mName	= (char*)(tb->mJsSName ? tb->mJsSName->vString : NULL);
			range.mStart= tb->mJsFrom ? tb->mJsFrom->vInt : 0;
			range.mCount= tb->mJsCount ? tb->mJsCount->vInt : -1;

			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryResourceList(&sref, &range);
			return task->call(qn, step+1);
		}
		break;

	case 1:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "Resource list load failed. %s",
						res->getMessagePtr());
			}
			tb->mList		= (ResultList*)res->mResult;
			res->mResult	= NULL;
			tb->mCount	= tb->mList->mList.values;
		}
	case 2:
		{
			if( step == 2 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode code	= res->getResultCode();
				if( code != ErrorOk ) {
					return taskResponse(q, code, "Resource info load failed. %s", res->getMessagePtr());
				}

				ResultResource *rsc = (ResultResource*)res->mResult;
				if( tb->mIndex == 0 ) {
					if( !tb->mJb.init(512) ||
						!tb->mJb.beginObject() ||
						!tb->mJb.addObjectProp("result", 6) ||
						!tb->mJb.valueInt(0) ||
						!tb->mJb.addObjectProp("sequence", 8) ||
						!tb->mJb.valueInt(task->getSequence()) ||
						!tb->mJb.addObjectProp("sid", 3) ||
						!tb->mJb.valueString(rsc->mResource.serviceId) ||
						!tb->mJb.addObjectProp("from", 4) ||
						!tb->mJb.valueInt(tb->mJsFrom ? tb->mJsFrom->vInt : 0) ||
						!tb->mJb.addObjectProp("resources", 9) ||
						!tb->mJb.beginArray() ) {
						taskLog(q, LOG_ERR, "json builder failed(1). code=%d.", tb->mJb.getError());
						return false;
					}
				}
				char _refTime[256];
				const char *refTime = "";
				if( rsc->mResource.refTime != 0 ) {
					struct tm *tmp = gmtime(&rsc->mResource.refTime);
					strftime(_refTime, sizeof(_refTime), "%Y/%m/%d-%H:%M:%S", tmp);
					refTime = _refTime;
				}
				const char *status = "unknown";
				switch(rsc->mResource.status) {
				case ResourceStop:	status = "stop";	break;
				case ResourceOpen:	status = "open";	break;
				case ResourceClose:	status = "close";	break;
				case ResourceError:	status = "error";	break;
				}

				if( !tb->mJb.addArrayContent() ||
					!tb->mJb.beginObject() ||
					!tb->mJb.addObjectProp("rid", 3) ||
					!tb->mJb.valueString(rsc->mResource.id ? rsc->mResource.id : "") ||
					!tb->mJb.addObjectProp("name", 4) ||
					!tb->mJb.valueString(rsc->mResource.name ? rsc->mResource.name : "") ||
					!tb->mJb.addObjectProp("revision", 8) ||
					!tb->mJb.valueInt(rsc->mResource.revision) ||
					!tb->mJb.addObjectProp("tag", 3) ||
					!tb->mJb.valueString(rsc->mResource.tag ? rsc->mResource.tag: "") ||
//					!tb->mJb.addObjectProp("refURL", 6) ||
//					!tb->mJb.valueString(rsc->mResource.refURL ? rsc->mResource.refURL : "") ||
					!tb->mJb.addObjectProp("refTime", 7) ||
					!tb->mJb.valueString(refTime) ||
//					!tb->mJb.addObjectProp("shareCount", 10) ||
//					!tb->mJb.valueInt(rsc->mResource.shareCount) ||
//					!tb->mJb.addObjectProp("status", 6) ||
//					!tb->mJb.valueString(status) ||
					!tb->mJb.endObject() ) {
					taskLog(q, LOG_ERR, "json builder failed(2). code=%d.", tb->mJb.getError());
					return false;
				}
				tb->mIndex++;
			}
			step	= 2;

			if( tb->mIndex < tb->mCount ) {
				QueryKeyType sref;
				QueryKeyType rref;

				sref.mId	= (char*)(tb->mJsSID ? tb->mJsSID->vString : NULL);
				sref.mName	= (char*)(tb->mJsSName ? tb->mJsSName->vString : NULL);
				rref.mId	= tb->mList->mList.value[tb->mIndex];
				rref.mName	= NULL;
				QnDBQuery *qn = new QnDBQuery(task);
				qn->queryResource(&sref, &rref);
				return task->call(qn, step);
			}

			if( tb->mCount > 0 ) {
				if( !tb->mJb.endArray() ||
					!tb->mJb.endObject() ) {
					taskLog(q, LOG_ERR, "json builder failed(3). code=%d.", tb->mJb.getError());
					return false;
				}
			} else {
				if( !tb->mJb.init(512) ||
					!tb->mJb.beginObject() ||
					!tb->mJb.addObjectProp("result", 6) ||
					!tb->mJb.valueInt(0) ||
					!tb->mJb.addObjectProp("sequence", 8) ||
					!tb->mJb.valueInt(task->getSequence()) ||
					!tb->mJb.endObject() ) {
					taskLog(q, LOG_ERR, "json builder failed(4). code=%d.", tb->mJb.getError());
					return false;
				}
			}
			return response(q,tb->mJb);
		}
		break;
	}
	taskLog(q, LOG_ERR, "unknown step. step=%d.", step);
	return false;
}

bool CommandProc::cmdShowResource(QueueNode *q)
{
	Task *task = q->getTask();
	int step = q->getStep();
	switch(step) {
	case 0:
		{
			QueryKeyType sref;
			QueryKeyType rref;
			sref.mId	= NULL;
			sref.mName	= NULL;
			rref.mId	= NULL;
			rref.mName	= NULL;
			pjson::json *jsCommand	= q->detouchJSONMessage();
			pjson::value *vCmd = jsCommand->get("showResource");
			if( vCmd ) {
				pjson::value *vSID		= jsCommand->get("sid", vCmd);
				pjson::value *vSName	= jsCommand->get("serviceName", vCmd);
				pjson::value *vRID		= jsCommand->get("rid", vCmd);
				pjson::value *vRName	= jsCommand->get("resourceName", vCmd);
				if( vSID && vSID->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"sid\" type.", codeToMessgae(ErrorParameter));
				}
				if( vRName && vRName->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"serviceName\" type.", codeToMessgae(ErrorParameter));
				}
				if( vRID && vRID->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"rid\" type.", codeToMessgae(ErrorParameter));
				}
				if( vRName && vRName->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"resourceName\" type.", codeToMessgae(ErrorParameter));
				}
				sref.mId	= (char*)(vSID ? vSID->vString : NULL);
				sref.mName	= (char*)(vSName ? vSName->vString : NULL);
				rref.mId	= (char*)(vRID ? vRID->vString : NULL);
				rref.mName	= (char*)(vRName ? vRName->vString : NULL);
			}
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryResource(&sref, &rref);
			delete jsCommand;
			return task->call(qn, step+1);
		}
		break;

	case 1:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "Resource info load error. %s", res->getMessagePtr());
			}

			ResultResource *rsc = (ResultResource*)res->mResult;

			char _refTime[256];
			const char *refTime = "";
			if( rsc->mResource.refTime != 0 ) {
				struct tm *tmp = gmtime(&rsc->mResource.refTime);
				strftime(_refTime, sizeof(_refTime), "%Y/%m/%d-%H:%M:%S", tmp);
				refTime = _refTime;
			}
			const char *status = "unknown";
			switch(rsc->mResource.status) {
			case ResourceStop:	status = "stop";	break;
			case ResourceOpen:	status = "open";	break;
			case ResourceClose:	status = "close";	break;
			case ResourceError:	status = "error";	break;
			}

			char _createTime[256];
			const char *createTime = "";
			if( rsc->mResource.createTime != 0 ) {
				struct tm *tmp = gmtime(&rsc->mResource.createTime);
				strftime(_createTime, sizeof(_createTime), "%Y/%m/%d-%H:%M:%S", tmp);
				createTime = _createTime;
			}
			char _updateTime[256];
			const char *updateTime = "";
			if( rsc->mResource.updateTime != 0 ) {
				struct tm *tmp = gmtime(&rsc->mResource.updateTime);
				strftime(_updateTime, sizeof(_updateTime), "%Y/%m/%d-%H:%M:%S", tmp);
				updateTime = _updateTime;
			}

			pjson::builder jb;
			if( !jb.init(256) ||
				!jb.beginObject() ||
				!jb.addObjectProp("result", 6) ||
				!jb.valueInt(0) ||
				!jb.addObjectProp("sequence", 8) ||
				!jb.valueInt(task->getSequence()) ||
				!jb.addObjectProp("rid", 3) ||
				!jb.valueString(rsc->mResource.id ? rsc->mResource.id  : "") ||
				!jb.addObjectProp("name", 4) ||
				!jb.valueString(rsc->mResource.name ? rsc->mResource.name : "") ||
				!jb.addObjectProp("tag", 3) ||
				!jb.valueString(rsc->mResource.tag ? rsc->mResource.tag: "") ||
				!jb.addObjectProp("refURL", 6) ||
				!jb.valueString(rsc->mResource.refURL ? rsc->mResource.refURL : "") ||
				!jb.addObjectProp("refTime", 7) ||
				!jb.valueString(refTime) ||
				!jb.addObjectProp("revision", 8) ||
				!jb.valueInt(rsc->mResource.revision) ||
				!jb.addObjectProp("shareCount", 10) ||
				!jb.valueInt(rsc->mResource.shareCount) ||
				!jb.addObjectProp("status", 6) ||
				!jb.valueString(status) ||
				!jb.addObjectProp("createTime", 10) ||
				!jb.valueString(createTime) ||
				!jb.addObjectProp("updateTime", 10) ||
				!jb.valueString(updateTime)  ) {
				taskLog(q, LOG_ERR, "json builder failed(1). code=%d", jb.getError());
				return false;
			}

			if( rsc->mResource.gadgetCount > 0 ) {
				if( !jb.addObjectProp("gadgets", 7) ||
					!jb.beginArray() ) {
					taskLog(q, LOG_ERR, "json builder failed(2). code=%d", jb.getError());
					return ErrorSystem;
				}
				size_t i;
				for( i = 0; i < rsc->mResource.gadgetCount; i++) {
					const char *refTime = "";
					if( rsc->mResource.gadgetArray[i].refTime != 0) {
						char _refTime[256];
						strftime(_refTime, sizeof(_refTime), "%Y/%m/%d-%H:%M:%S", gmtime(&rsc->mResource.gadgetArray[i].refTime));
						refTime = _refTime;
					}
					const char *status = "unknown";
					switch(rsc->mResource.gadgetArray[i].status) {
					case ResourceStop:	status = "stop";	break;
					case ResourceOpen:	status = "open";	break;
					case ResourceClose:	status = "close";	break;
					case ResourceError:	status = "error";	break;
					}
					if( !jb.addArrayContent() ||
						!jb.beginObject() ||
						!jb.addObjectProp("id", 2) ||
						!jb.valueString(rsc->mResource.gadgetArray[i].id ? rsc->mResource.gadgetArray[i].id : "") ||
						!jb.addObjectProp("name", 4) ||
						!jb.valueString(rsc->mResource.gadgetArray[i].name ? rsc->mResource.gadgetArray[i].name : "") ||
						!jb.addObjectProp("tag", 3) ||
						!jb.valueString(rsc->mResource.gadgetArray[i].tag ? rsc->mResource.gadgetArray[i].tag : "") ||
						!jb.addObjectProp("refTime", 7) ||
						!jb.valueString(refTime) ||
						!jb.addObjectProp("status", 6) ||
						!jb.valueString(status) ||
						!jb.addObjectProp("revision", 8) ||
						!jb.valueInt(rsc->mResource.gadgetArray[i].revision) ||
						!jb.endObject() ) {
						taskLog(q, LOG_ERR, "json builder failed(3). code=%d", jb.getError());
						return ErrorSystem;
					}
				}
				if( !jb.endArray() ) {
					taskLog(q, LOG_ERR, "json builder failed(4). code=%d", jb.getError());
					return ErrorSystem;
				}
			}

			if(	!jb.endObject() ) {
				taskLog(q, LOG_ERR, "json builder failed(5). code=%d", jb.getError());
				return false;
			}
			return response(q,jb);
		}
		break;
	}
	taskLog(q, LOG_ERR, "unknown step. step=%d.", step);
	return false;
}

}





