/*
 * cyclicBuffer.h
 *
 *  Created on: 2012/12/08
 *      Author: yasuoki
 */

#ifndef CYCLICBUFFER_H_
#define CYCLICBUFFER_H_

#include "../include/sst_types.h"
#include "buffer.h"

namespace SST {

class CyclicBuffer : public Buffer{
public:
	CyclicBuffer();
	~CyclicBuffer();
private:
	CyclicBuffer(const CyclicBuffer &c);
	CyclicBuffer &operator=(const CyclicBuffer &c);
public:
	bool	add(const char *data, ssize_t size);
	size_t	size() const;
	size_t	get(char *buff, size_t buffSize);
	size_t	getLine(char *buff, size_t buffSize);
	size_t	getAt(char *buff, size_t start, size_t len) const;
	const char *getPtr() const;
	void	clear();
	bool	empty() const { return nRead == nWrite; }
#ifdef _DEBUG
	bool	ptrTest(size_t a, size_t r, size_t w);
#endif
protected:
	size_t	getFreeSpace(size_t &nLeft, size_t &nRight) const;
	size_t	getUsingSpace(size_t &nLeft, size_t &nRight) const;

	size_t	nAlloc;
	size_t	nWrite;
	size_t	nRead;
	char *	ptr;
};

}

#endif /* CYCLICBUFFER_H_ */
