/*
 * device_slot.h
 *
 *  Created on: 2012/06/13
 *      Author: yasuoki
 */

#ifndef DEVICE_SLOT_H_
#define DEVICE_SLOT_H_

#include "../include/sst_types.h"

namespace SST {

class DeviceSlot
{
public:
	DeviceSlot();
	~DeviceSlot();

	DeviceSlotStatus	getStatus();
	bool		setStatus(DeviceSlotStatus st);
	bool		setDevice(DeviceInfo *dev);
	DeviceInfo *	getDevice();
	void		closeDevice();

protected:
	DeviceSlotStatus	status;
	DeviceInfo *			device;
};

class DeviceSlotList
{
public:
	DeviceSlotList();
	~DeviceSlotList();

	bool 	configure(Sentinel *obj, Conf *conf);
	bool	allocSlot(size_t size);
	void	clear();
	size_t	getSlotCount();

protected:
	Sentinel *	mSentinel;
	size_t		mSlots;
	size_t		mAllocs;
	DeviceSlot **mSlotList;
};

}

#endif /* DEVICE_SLOT_H_ */
