/*
 * lock.cpp
 *
 *  Created on: 2012/03/05
 *      Author: yasuoki
 */

#include "lock.h"
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <time.h>
#include <errno.h>


namespace SST {

LockObject::LockObject()
{
	pthread_rwlock_init(&rwlock, NULL);
#ifdef _DEBUG
	_xReadLockCnt		= 0;
	_xWriteLockThread	= 0;
	_xWriteLocked		= false;
	_xLastLockSrc		= NULL;
	_xLastLockLine		= 0;
#endif
}
LockObject::~LockObject()
{
	pthread_rwlock_destroy(&rwlock);
}

void LockObject::readLock(
#ifdef _DEBUG
		const char *f, int l
#endif
		)
{
#ifdef _LOCK_DEBUG
	fprintf(stderr, "%8.8X: RL %x try %d\n", pthread_self(), &rwlock, _xReadLockCnt);
	assert( !(_xWriteLocked && _xWriteLockThread == pthread_self()));
#endif
#ifdef USE_TIMEOUT
	pthread_t th = pthread_self();
	timespec wt;
	timespec st;
	clock_gettime(CLOCK_REALTIME, &st);
	wt.tv_nsec	= st.tv_nsec;
	wt.tv_sec	= st.tv_sec + 3;
	int e;
	if( (e = pthread_rwlock_timedrdlock(&rwlock, &wt)) != 0 ) {
		const char *v="unknown";
		switch(e) {
		case ETIMEDOUT:	v	= "ETIMEDOUT";	break;
		case EAGAIN:	v	= "EAGAIN";		break;
		case EDEADLK:	v	= "EDEADLK";	break;
		case EINVAL:	v	= "EINVAL";		break;
		}
		timespec et;
		clock_gettime(CLOCK_REALTIME, &et);
		int rt = st.tv_sec - et.tv_sec;

		fprintf(stderr, "%8.8X: *** read lock error %s lock=%x secs=%d s=%u e=%u w=%u ***\n",  (unsigned int)th,  v, (unsigned int)&rwlock, rt, (unsigned int)st.tv_sec, (unsigned int)et.tv_sec, (unsigned int)wt.tv_sec);
		fprintf(stderr, "%8.8X: * read lock count = %d write lock thread = %8.8X\n",  (unsigned int)th, _xReadLockCnt, (unsigned int)_xWriteLockThread);
		fprintf(stderr, "%8.8X: * call from %s:%d\n",  (unsigned int)th,  f, l);
		fprintf(stderr, "%8.8X: * last lock %s:%d\n",  (unsigned int)th,  _xLastLockSrc, _xLastLockLine);
		assert(false);
	}
#else
	pthread_rwlock_rdlock(&rwlock);
#endif
	_xReadLockCnt++;
	_xWriteLockThread	= NULL;
	_xWriteLocked		= false;
	_xLastLockSrc		= f;
	_xLastLockLine		= l;
#ifdef _DEBUG
#ifdef _LOCK_DEBUG
	fprintf(stderr, "%8.8X: RL %x ok %d\n", pthread_self(), &rwlock, _xReadLockCnt);
#endif
#endif
}
void LockObject::writeLock(
#ifdef _DEBUG
		const char *f, int l
#endif
		)
{
#ifdef _LOCK_DEBUG
	fprintf(stderr, "%8.8X: WL %x try\n", pthread_self(), &rwlock);
	assert( !(_xWriteLocked && _xWriteLockThread == pthread_self()));
#endif
#ifdef _DEBUG
	pthread_t th = pthread_self();
#endif
#ifdef USE_TIMEOUT
	if( _xWriteLocked && _xWriteLockThread == th ) {
		fprintf(stderr, "%8.8X: *** write lock failed lock=%x ***\n",  (unsigned int)th,  (unsigned int)&rwlock);
		fprintf(stderr, "%8.8X: * read lock count = %d write lock thread = %8.8X\n",  (unsigned int)th, _xReadLockCnt, (unsigned int)_xWriteLockThread);
		fprintf(stderr, "%8.8X: * call from %s:%d\n",  (unsigned int)th,  f, l);
		fprintf(stderr, "%8.8X: * last lock %s:%d\n",  (unsigned int)th,  _xLastLockSrc, _xLastLockLine);
		assert(false);
	}
	timespec wt;
	timespec st;
	clock_gettime(CLOCK_REALTIME, &st);
	wt.tv_nsec	= st.tv_nsec;
	wt.tv_sec	= st.tv_sec + 3;
	int e;
	if( (e = pthread_rwlock_timedwrlock(&rwlock, &wt)) != 0 ) {
		const char *v="unknown";
		switch(e) {
		case ETIMEDOUT:	v	= "ETIMEDOUT";	break;
		case EAGAIN:	v	= "EAGAIN";	break;
		case EDEADLK:	v	= "EDEADLK";	break;
		case EINVAL:	v	= "EINVAL";		break;
		}
		timespec et;
		clock_gettime(CLOCK_REALTIME, &et);
		int rt = st.tv_sec - et.tv_sec;
		fprintf(stderr, "%8.8X: *** write lock error %s lock=%x sec=%d s=%u e=%u w=%u ***\n",  (unsigned int)th,  v, (unsigned int)&rwlock,rt,(unsigned int)st.tv_sec,(unsigned int)et.tv_sec, (unsigned int)wt.tv_sec);
		fprintf(stderr, "%8.8X: * read lock count = %d write lock thread = %8.8X\n",  (unsigned int)th, _xReadLockCnt, (unsigned int)_xWriteLockThread);
		fprintf(stderr, "%8.8X: * call from %s:%d\n",  (unsigned int)th,  f, l);
		fprintf(stderr, "%8.8X: * last lock %s:%d\n",  (unsigned int)th,  _xLastLockSrc, _xLastLockLine);
		assert(false);
	}
#else
	pthread_rwlock_wrlock(&rwlock);
#endif
#ifdef _DEBUG
	_xWriteLocked = true;
	_xWriteLockThread	= th;
	_xLastLockSrc	= f;
	_xLastLockLine	= l;
#ifdef _LOCK_DEBUG
	fprintf(stderr, "%8.8X: WL %x ok\n", pthread_self(), &rwlock);
#endif
#endif
}
void LockObject::unlock()
{
	pthread_rwlock_unlock(&rwlock);
#ifdef _DEBUG
	_xWriteLockThread	= NULL;
	_xWriteLocked		= false;
	if( _xReadLockCnt != 0 ) {
		_xReadLockCnt--;
#ifdef _LOCK_DEBUG
		fprintf(stderr, "%8.8X: UL %x %d -> %d\n", pthread_self(), &rwlock, _xReadLockCnt+1, _xReadLockCnt);
#endif
		} else {
#ifdef _LOCK_DEBUG
		fprintf(stderr, "%8.8X: UL %x\n", pthread_self(), &rwlock);
#endif
	}
#endif
}

}



