/*
 * processor.h
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#ifndef PROCESSOR_H_
#define PROCESSOR_H_

#include "../include/sst_types.h"
#include "commands.h"
#include "queue.h"
#include "pjson.h"
#include "process.h"
#include "task.h"
#include "proc_database.h"
#include <pthread.h>
#include <string.h>

namespace SST {

typedef struct _SyncData SyncData;

class QnCommSync : public QueueNode
{
public:
	enum SyncMode {
		SyncModeAdd		= 0,
		SyncModeUpdate	= 1,
		SyncModeRemove	= 2,
	};
private:
	QnCommSync(const QnCommSync &d);
public:
	QnCommSync(Task *task);
	virtual ~QnCommSync();
	bool setSync(ServiceInfo *svc, QueryKeyType *rref, const char *ref, QnCommSync::SyncMode mode);

	SyncData *	mData;
};

struct _SyncData {
	ServiceInfo 		mService;
	QueryKeyType		mRRef;
	char *				mRef;
	QnCommSync::SyncMode mMode;
};


class CommandProc : public Process {
public:
	CommandProc();
	virtual ~CommandProc();

	virtual bool	configure(Sentinel *obj, Conf *conf);
	virtual void	clear();
	virtual const char *getName() const { return "Command"; }
	virtual const char *getFuncName(int id);

	virtual bool	exec(QueueNode *q);
	virtual void	stop(QueueNode *q);

protected:
	bool	response(QueueNode *q, pjson::builder &jb);

	bool	syncParseInfo(bool &endTask, TaskBuffer *tb, QueueNode *q, int step);
	bool	syncParseShareInfo(bool &endTask, TaskBuffer *tb, QueueNode *q, int step);
	bool	syncCompareUpdate(bool &endTask, bool &diff, TaskBuffer *tb, QueueNode *q, int step);

	bool	cmdExit(QueueNode *q);
	bool	cmdLogin(QueueNode *q);

	bool	cmdRegAccount(QueueNode *q);
	bool	cmdSetAccount(QueueNode *q);
	bool	cmdRmAccount(QueueNode *q);
//	bool	cmdEraseAccount(QueueNode *q);
	bool	cmdLsAccount(QueueNode *q);
	bool	cmdShowAccount(QueueNode *q);
	bool	cmdLockAccount(QueueNode *q);
	bool	cmdUnlockAccount(QueueNode *q);

	bool	cmdRmDevice(QueueNode *q);
	bool	cmdLsDevice(QueueNode *q);
	bool	cmdShowDevice(QueueNode *q);

	bool	cmdRegService(QueueNode *q);
	bool	cmdSetService(QueueNode *q);
	bool	cmdRmService(QueueNode *q);
	bool	cmdLsService(QueueNode *q);
	bool	cmdShowService(QueueNode *q);
	bool	cmdLsServiceGroup(QueueNode *q);

	bool	cmdAddGroup(QueueNode *q);
	bool	cmdSetGroup(QueueNode *q);
	bool	cmdRmGroup(QueueNode *q);
	bool	cmdLsGroup(QueueNode *q);
	bool	cmdShowGroup(QueueNode *q);
	bool	cmdJoinGroup(QueueNode *q);
	bool	cmdLeaveGroup(QueueNode *q);
	bool	cmdLsGroupUser(QueueNode *q);

	bool	cmdRmResource(QueueNode *q);
	bool	cmdLsResource(QueueNode *q);
	bool	cmdShowResource(QueueNode *q);

	bool	cmdShare(QueueNode *q);
	bool	cmdUnshare(QueueNode *q);
	bool	cmdShowShare(QueueNode *q);
	bool	cmdLsGroupShare(QueueNode *q);
	bool	cmdLsResourceShare(QueueNode *q);
	bool	cmdLsDeviceShare(QueueNode *q);

	bool	cmdUpdate(QueueNode *q);
	bool	cmdSync(QueueNode *q);
	bool	cmdSyncQueue(QueueNode *q);
	bool	cmdSyncStat(QueueNode *q);
	bool	cmdSyncGroup(QueueNode *q);
	bool	cmdSyncAccount(QueueNode *q);
	bool	cmdSyncDevice(QueueNode *q);
	bool	cmdDownSync(QueueNode *q);
	bool	cmdUpSync(QueueNode *q);

	bool	cmdDiagSession(QueueNode *q);
	bool	cmdDiagTask(QueueNode *q);
	bool	cmdDiagQueue(QueueNode *q);
	bool	cmdDiagProcess(QueueNode *q);
	bool	cmdDiagThread(QueueNode *q);
	bool	cmdDiagRevKey(QueueNode *q);
	bool	cmdDebugTest(QueueNode *q);

};

}

#endif /* PROCESSOR_H_ */
