/*
 * redis_db.h
 *
 *  Created on: 2012/12/11
 *      Author: yasuoki
 */

#ifndef REDIS_DB_H_
#define REDIS_DB_H_

#include "../include/sst_types.h"
#include "pjson.h"
#include "db_port.h"
#include <sys/types.h>
#include <pthread.h>

struct redisContext;
struct redisReply;

namespace SST {

class RedisDB : public DBPort
{
public:
	RedisDB();
	virtual ~RedisDB();

	virtual bool	configure(Sentinel *obj, Conf *conf);
//	virtual bool	checkAccountName(const char *name);
	virtual bool	connect();
	virtual void	close();

	virtual ErrorCode getAccountId(const char *uid, char *id_ret);
	virtual ErrorCode setAccountInfo(Account *account, char *id_ret);
	virtual ErrorCode getAccountInfo(const char *id, ResultAccount **account);
	virtual ErrorCode remAcocuntInfo(const char *id);
	virtual ErrorCode getAccountCount(size_t &nRec);
	virtual ErrorCode getAccountList(size_t nFrom, size_t nCount, ResultList **pList);
	virtual ErrorCode getAccountDeviceCount(const char *aid, size_t &nRec);
	virtual ErrorCode getAccountDeviceList(const char *aid, size_t nFrom, size_t nCount, ResultList **pList);
	virtual ErrorCode getAccountGroupCount(const char *aid, size_t &nRec);
	virtual ErrorCode getAccountGroupList(const char *aid, size_t nFrom, size_t nCount, ResultList **pList);

	virtual ErrorCode getDeviceId(const char *udid, char *id_ret);
	virtual ErrorCode setDeviceInfo(DeviceInfo *device, char *id_ret);
	virtual ErrorCode getDeviceInfo(const char *id, ResultDevice **device);
	virtual ErrorCode remDeviceInfo(const char *id);
	virtual ErrorCode getDeviceCount(size_t &nRec);
	virtual ErrorCode getDeviceList(size_t nFrom, size_t nCount, ResultList **pList);
	virtual ErrorCode setDeviceShareInfo(const char *did, const DeviceShareInfo *shareInfo);
	virtual ErrorCode remDeviceShareInfo(const char *did, const char *mid);
	virtual ErrorCode getDeviceShareCount(const char *did, size_t &nRec);
	virtual ErrorCode getDeviceShareList(const char *did, size_t nFrom, size_t nCount, ResultList **pList);

	virtual ErrorCode getServiceId(const char *name, char *id_ret);
	virtual ErrorCode setServiceInfo(ServiceInfo *si, char *id_ret);
	virtual ErrorCode getServiceInfo(const char *id, ResultService **res);
	virtual ErrorCode getServicePWList(const char *id, size_t nFrom, size_t nCount, ResultList **pList);
	virtual ErrorCode isServiceWritable(const char *sid, const char *aid);
	virtual ErrorCode getServicePRList(const char *id, size_t nFrom, size_t nCount, ResultList **pList);
	virtual ErrorCode isServiceReadable(const char *sid, const char *aid);
	virtual ErrorCode remServiceInfo(const char *id);
	virtual ErrorCode setServiceRefuseList(const char *sid, const char *aid);
	virtual ErrorCode remServiceRefuseList(const char *sid, const char *aid);
	virtual ErrorCode isServiceRefuse(const char *sid, const char *aid);
	virtual ErrorCode getServiceCount(size_t &nRec);
	virtual ErrorCode getServiceList(size_t nFrom, size_t nCount, ResultList **pList);
//	virtual DBError	getServiceSessionCount(const char *rid, size_t &nRec);
//	virtual DBError	getServiceSessionList(const char *rid, size_t nFrom, size_t nCount, ResultList **pList);
	virtual ErrorCode getServiceGroupCount(const char *sid, size_t &nRec);
	virtual ErrorCode getServiceGroupList(const char *sid, size_t nFrom, size_t nCount, ResultList **pList);
	virtual ErrorCode getServiceResourceCount(const char *sid, size_t &nRec);
	virtual ErrorCode getServiceResourceList(const char *sid, size_t nFrom, size_t nCount, ResultList **pList);

	virtual ErrorCode getGroupId(const char *sid, const char *name, char *id_ret);
	virtual ErrorCode setGroup(GroupInfo *g, char *id_ret);
	virtual ErrorCode getGroup(const char *gid, ResultGroup **res);
	virtual ErrorCode remGroup(const char *gid);
	virtual ErrorCode getGroupAccountCount(const char *gid, size_t &nRec);
	virtual ErrorCode getGroupAccountList(const char *gid, size_t nFrom, size_t nCount, ResultList **pList);
	virtual ErrorCode getGroupShareCount(const char *gid, size_t &nRec);
	virtual ErrorCode getGroupShareList(const char *gid, size_t nFrom, size_t nCount, ResultList **pList);

	virtual ErrorCode isGroupAccount(const char *gid, const char *aid);
	virtual ErrorCode joinGroupAccount(const char *gid, const char *aid);
	virtual ErrorCode leaveGroupAccount(const char *gid, const char *aid);

	virtual ErrorCode getResourceId(const char *sid, const char *name, char *id_ret);
	virtual ErrorCode setResourceInfo(ResourceInfo *r, char *id_ret);
	virtual ErrorCode getResourceInfo(const char *rid, ResultResource **res);
	virtual ErrorCode remResourceInfo(const char *rid);
//	virtual ErrorCode getGadgetId(const char *rid, const char *name, char *id_ret);
	virtual ErrorCode getResourceShareCount(const char *rid, size_t &nRec);
	virtual ErrorCode getResourceShareList(const char *rid, size_t nFrom, size_t nCount, ResultList **pList);

	virtual ErrorCode getShareInfo(const char *mid, ResultShare **res);
	virtual ErrorCode setShareInfo(ShareInfo *m, char *id_ret);
	virtual ErrorCode remShareInfo(const char *mid);

	virtual ErrorCode pushSyncQueue(const char *sid, const char *gid);
	virtual ErrorCode popSyncQueue(const char *sid, char *idRet);

/*
	virtual DBError getSessionId(const char *peerAddr, char *id_ret);
	virtual DBError	setSession(const SessionInfo *session, char *id_ret);
	virtual DBError getSession(const char *ssid, ResultSession **res);
	virtual DBError	remSession(const char *ssid);
	virtual DBError	getSessionCount(const char *rid, size_t &nRec);
	virtual DBError	getSessionList(const char *rid, size_t nFrom, size_t nCount, ResultList **pList);
*/
protected:
	ErrorCode getJson(pjson::json **jb, const char *msg, const char *cmd, ...);
	ErrorCode getInt(long long int &v, const char *msg, const char *fmt, ...);
	ErrorCode getStr(redisReply **rep, const char *msg, const char *fmt, ...);
	ErrorCode execStatusCommand(const char *msg, const char *fmt, ...);
	ResultList *createListResult(const redisReply *rep, size_t nFrom, size_t nCount);
	ErrorCode getListCount(const char *key, size_t &nRec);
	ErrorCode getListList(const char *key, size_t nFrom, size_t nCount, ResultList **pList);
	ErrorCode getKeyCount(const char *key, size_t &nRec);
	ErrorCode getKeyList(const char *key, size_t nFrom, size_t nCount, ResultList **pList);
	ErrorCode getSetCount(const char *key, size_t &nRec);
	ErrorCode getSetList(const char *key, size_t nFrom, size_t nCount, ResultList **pList);
	ErrorCode isSetMember(const char *key, const char *member, bool *res);

	char		mAuth[256];
	char		mServer[256];
	int			mPort;
	redisContext *mConn;
};

}

#endif /* REDIS_DB_H_ */
