<?php

function get_info($r) {
	$enc = json_encode("palette-".$r,JSON_UNESCAPED_UNICODE);
	$js = <<<ENDJSON
{
	"resource":{
		"name":$enc,
		"date":"2012/12/05-20:59:01",
		"tag":"pal",
		"gadget": [
			{
				"name":"image",
				"date":"2012/12/05-20:59:01",
				"tag":"img,jpeg"
			}
		]
	}
}
ENDJSON;
	return $js;
}

function get_shareinfo($r) {
	$groupName = "group" . ($r % 3 +1);
	$enc = json_encode($groupName);
	$js = <<<ENDJSON
{
	"share_info":[
		{
			"groups":[
				{ "groupName":$enc }
			]
		}
	]
}
ENDJSON;
	return $js;
}

function opt_unknown($r) {
	$e = json_encode($r);
	$js = <<<ENDJSON
{
	"error":{
		"msg":"$r"
	}
}
ENDJSON;
	return $js;
}

$me  = $_SERVER["SCRIPT_NAME"];
$url = $_SERVER["PHP_SELF"];
$vp  = substr($url,strlen($me));
$pm  = preg_split("[/]", $vp, 0, PREG_SPLIT_NO_EMPTY);
$pm_cnt = count($pm);
if( $pm_cnt < 2 ) {
	echo opt_unknown("parameter is not specifed");
	exit();
}
$res = $pm[0];
$opt = $pm[1];

if( $opt == 'info' ) {
	echo get_info($res);
} else if( $opt == 'share_info' ) {
	echo get_shareinfo($res);
} else {
	echo opt_unknown("unknown option \"".$opt."\"");
}
?>

