/*
 * cmd_login.cpp
 *
 *  Created on: 2012/12/28
 *      Author: yasuoki
 */

#include "commands.h"
#include "proc_command.h"
#include "proc_database.h"
#include "proc_requester.h"
#include "task.h"
#include "sentinel.h"
#include "buffer.h"
#include "pjson.h"
#include <syslog.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

namespace SST {

class TBLogin : public TaskBuffer {
public:
	TBLogin() {
		mCommand	= NULL;
		mJsSID		= NULL;
		mJsSName	= NULL;
		mJsUID		= NULL;
		mJsAID		= NULL;

		mJsResponse	= NULL;
		mJsPasswd	= NULL;
		mJsNonce	= NULL;
		mJsCnonce	= NULL;
		mJsAlgo		= NULL;

		mJsDevice	= NULL;
		mJsDevOs	= NULL;
		mJsDevOsv	= NULL;
		mJsUdid		= NULL;
		mJsDevModel	= NULL;
		mJsDevCa	= NULL;
		mJsBlockSize	= NULL;
		mJsBlockCount	= NULL;
		mJsStorageUse	= NULL;
		mJsStorageCrypt	= NULL;

		mService	= NULL;
		mAccount	= NULL;
		mDevice		= NULL;
		mRebuildDevice	= false;
	}
	virtual ~TBLogin() {
		if( mCommand ) delete mCommand;
		if( mService ) free(mService);
		if( mAccount ) free(mAccount);
		if( mDevice )  free(mDevice);
	}
	pjson::json *	mCommand;
	pjson::value *	mJsSID;
	pjson::value *	mJsSName;
	pjson::value *	mJsUID;
	pjson::value *	mJsAID;

	pjson::value *	mJsResponse;
	pjson::value *	mJsPasswd;
	pjson::value *	mJsNonce;
	pjson::value *	mJsCnonce;
	pjson::value *	mJsAlgo;

	pjson::value *	mJsDevice;
	pjson::value *	mJsDevOs;
	pjson::value *	mJsDevOsv;
	pjson::value *	mJsUdid;
	pjson::value *	mJsDevModel;
	pjson::value *	mJsDevCa;
	pjson::value *	mJsBlockSize;
	pjson::value *	mJsBlockCount;
	pjson::value *	mJsStorageUse;
	pjson::value *	mJsStorageCrypt;

	ResultService *	mService;
	ResultAccount *	mAccount;
	ResultDevice *	mDevice;
	bool			mRebuildDevice;
};

bool CommandProc::cmdLogin(QueueNode *q)
{
	Task *task = q->getTask();
	int step = q->getStep();
	Session *con = task->getSession();

	TBLogin *tb = (TBLogin *)task->getTaskBuffer();
	if( tb == NULL ) {
		tb = new TBLogin();
		if( tb == NULL ) {
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
		if( !task->setTaskBuffer(tb) ) {
			delete tb;
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
 	}

	switch(step) {
	case 0:
		{
			tb->mCommand	= q->detouchJSONMessage();
			pjson::value *vCmd = tb->mCommand->get("login");
			if( !vCmd ) {
				return taskResponse(q, ErrorParameter, "%s. \"login\" is not object.", codeToMessgae(ErrorParameter));
			}

			tb->mJsSName	= tb->mCommand->get("serviceName", vCmd);
			tb->mJsSID		= tb->mCommand->get("sid", vCmd);
			tb->mJsUID		= tb->mCommand->get("userId", vCmd);
			tb->mJsAID		= tb->mCommand->get("aid", vCmd);
			if( tb->mJsSName && tb->mJsSName->vt != pjson::vt_string )
				return taskResponse(q, ErrorParameter, "%s. \"serviceName\" type.", codeToMessgae(ErrorParameter));
			if( tb->mJsSID && tb->mJsSID->vt != pjson::vt_string )
				return taskResponse(q, ErrorParameter, "%s. \"sid\" type.", codeToMessgae(ErrorParameter));
			if( tb->mJsUID && tb->mJsUID->vt != pjson::vt_string )
				return taskResponse(q, ErrorParameter, "%s. \"userId\" type.", codeToMessgae(ErrorParameter));
			if( tb->mJsAID && tb->mJsAID->vt != pjson::vt_string )
				return taskResponse(q, ErrorParameter, "%s. \"aid\" type.", codeToMessgae(ErrorParameter));

			pjson::value *vDevice = tb->mCommand->get("device", vCmd);
			if( vDevice ) {
				if( vDevice->vt != pjson::vt_object ) {
					return taskResponse(q, ErrorParameter, "%s. \"device\" is not object.", codeToMessgae(ErrorParameter));
				}
				tb->mJsDevice	= vDevice;
				tb->mJsUdid 	= tb->mCommand->get("udid", vDevice);
				tb->mJsDevOs 	= tb->mCommand->get("os", vDevice);
				tb->mJsDevOsv 	= tb->mCommand->get("osVersion", vDevice);
				tb->mJsDevModel	= tb->mCommand->get("model", vDevice);
				tb->mJsDevCa 	= tb->mCommand->get("carrier", vDevice);
				tb->mJsBlockSize	= tb->mCommand->get("blockSize", vDevice);
				tb->mJsBlockCount	= tb->mCommand->get("blockCount", vDevice);
				tb->mJsStorageUse	= tb->mCommand->get("storageUse", vDevice);
				tb->mJsStorageCrypt	= tb->mCommand->get("storageCrypt", vDevice);
				if( tb->mJsUdid && tb->mJsUdid->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"udid\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsDevOs && tb->mJsDevOs->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"OS\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsDevOsv && tb->mJsDevOsv->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"OSVersion\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsDevModel && tb->mJsDevModel->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"model\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsDevCa && tb->mJsDevCa->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"carrier\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsBlockSize && tb->mJsBlockSize->vt != pjson::vt_int)
					return taskResponse(q, ErrorParameter, "%s. \"blockSize\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsBlockCount && tb->mJsBlockCount->vt != pjson::vt_int)
					return taskResponse(q, ErrorParameter, "%s. \"blockCount\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsStorageUse && tb->mJsStorageUse->vt != pjson::vt_int)
					return taskResponse(q, ErrorParameter, "%s. \"storageUse\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsStorageCrypt && tb->mJsStorageCrypt->vt != pjson::vt_string)
					return taskResponse(q, ErrorParameter, "%s. \"storageCrypt\" type.", codeToMessgae(ErrorParameter));

				if( tb->mJsUdid == NULL )
					return taskResponse(q, ErrorParameter, "%s. \"udid\" is not specified.", codeToMessgae(ErrorParameter));
			}
			pjson::value *vAuth = tb->mCommand->get("auth", vCmd);
			if( vAuth ) {
				if( vAuth->vt != pjson::vt_object )
					return taskResponse(q, ErrorParameter, "auth type");
				tb->mJsResponse = tb->mCommand->get("response", vAuth);
				tb->mJsPasswd	= tb->mCommand->get("password", vAuth);
				tb->mJsNonce	= tb->mCommand->get("nonce", vAuth);
				tb->mJsCnonce	= tb->mCommand->get("cnonce", vAuth);
				tb->mJsAlgo		= tb->mCommand->get("algorithm", vAuth);
				if( tb->mJsResponse && tb->mJsResponse->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"response\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsPasswd && tb->mJsPasswd->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"password\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsNonce && tb->mJsNonce->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"nonce\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsCnonce && tb->mJsCnonce->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"cnonce\" type.", codeToMessgae(ErrorParameter));
				if( tb->mJsAlgo && tb->mJsAlgo->vt != pjson::vt_string )
					return taskResponse(q, ErrorParameter, "%s. \"algorithm\" type.", codeToMessgae(ErrorParameter));
			}

			if( tb->mJsUID == NULL && tb->mJsAID == NULL ) {
				return taskResponse(q, ErrorParameter, "%s. account is not specified.", codeToMessgae(ErrorParameter));
			}

			// check service id
			QueryKeyType key;
			if( tb->mJsSID == NULL && tb->mJsSName == NULL ) {
				key.mId		= "S1";
				key.mName	= NULL;
			} else {
				key.mId		= tb->mJsSID ? tb->mJsSID->vString : NULL;
				key.mName	= tb->mJsSName ?tb->mJsSName->vString : NULL;
			}
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryService(&key);
			return task->call(qn, step+1);
		}
		break;

	case 1:
		// service info
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, ErrorDatabase, "Service info load faild. %s", res->getMessagePtr());
			}

			tb->mService	= (ResultService*)(res->mResult);
			res->mResult	= NULL;
			const char *uid = task->getUserId();
			const char *sid = task->getServiceId();
			if( uid ) {
				if( sid ) {
					taskLog(q, LOG_INFO, "user %s logoff from %s.", uid, sid);
				} else {
					taskLog(q, LOG_INFO, "user %s logoff.", uid);
				}
			}
			con->setAccountLevel(AccountSystemService);
			con->setAccountId(NULL);
			con->setUserId(NULL);
			con->setServiceId(NULL);
			con->setStatus(SessionStatusConnect);

			// get account info
			QueryKeyType key;
			key.mId		= tb->mJsAID ? tb->mJsAID->vString : NULL;
			key.mName	= tb->mJsUID ? tb->mJsUID->vString : NULL;
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryAccount(&key);
			return task->call(qn, step+1);
		}
		break;

	case 2:
		{	// account info
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode	code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "Account info load failed. %s", res->getMessagePtr());
			}

			tb->mAccount = (ResultAccount*)res->mResult;
			res->mResult = NULL;

			if( tb->mAccount->mAccount.status != AccountNormal ) {
				return taskResponse(q, ErrorAuth, "%s. login error. account=%s,%s is inactive.",
						codeToMessgae(ErrorAuth),
						tb->mAccount->mAccount.id, tb->mAccount->mAccount.uid);
			}
			// TODO: 一般ユーザでもOKかも？
//			if( tb->mService == NULL && tb->mAccount->mAccount.level != AccountSystemAdmin ) {
//				return taskResponse(q, ErrorNotFound, "login error. code=%d. service is not found.", code);
//			}

			if( tb->mService ) {
				QnDBQuery *qn = new QnDBQuery(task);
				QueryKeyType sref;
				sref.mId	= tb->mService->mService.id;
				sref.mName	= NULL;
				QueryKeyType aref;
				aref.mId	= tb->mAccount->mAccount.id;
				aref.mName	= NULL;
				qn->queryAccountIsLock(&sref, &aref);
				return task->call(qn, step+1);
			}
		}
	case 3:
		{
			if( step == 3 ) {
				// account locked list
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode	code	= res->getResultCode();
				if( code == ErrorOk ) {
					return taskResponse(q, ErrorAuth, "%s. Login error. account=%s,%s is locked by service %s.",
							codeToMessgae(ErrorAuth),
							tb->mAccount->mAccount.id, tb->mAccount->mAccount.uid,
							tb->mService->mService.name);
				} else {
					if( code != ErrorNotFound ) {
						return taskResponse(q, code, "Login error. %s", res->getMessagePtr());
					}
				}

				if( tb->mService->mService.scope == ScopePrivate &&
					strcmp(tb->mService->mService.adminId, tb->mAccount->mAccount.id) != 0 ) {
					QueryKeyType sref;
					QueryKeyType gref;
					QueryKeyType aref;
					sref.mId	= tb->mService->mService.id;
					sref.mName	= NULL;
					gref.mId	= NULL;
					gref.mName	= NULL;
					aref.mId	= tb->mAccount->mAccount.id;
					aref.mName	= NULL;
					QnDBQuery *qn = new QnDBQuery(task);
					qn->queryGroupMember(&sref, &gref, &aref);
					return task->call(qn, step+1);
				}
			}
			step = 3;
		}
	case 4:
		{	// group member
			if( step == 4 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode	code	= res->getResultCode();
				if( code != ErrorOk ) {
					return taskResponse(q, ErrorAuth, "Account is not join service group. %s", res->getMessagePtr());
				}
			}
			step	= 4;

			if( tb->mService ) {
				if( tb->mService->mService.authType == AuthExternURL  ) {
					if( !tb->mJsPasswd ) {
						return taskResponse(q, ErrorAuth, "%s. Login error.", codeToMessgae(ErrorAuth));
					}
					if( !tb->mService->mService.authData) {
						taskLog(q, LOG_WARNING, "%s. Service authURL is not specified. service=%s,%s.",
								codeToMessgae(ErrorDataConflict),
								tb->mService->mService.id, tb->mService->mService.name);
						return taskResponse(q, ErrorAuth, "%s. Login error.", codeToMessgae(ErrorAuth));
					}
					QnHTTPRequest *qht = new QnHTTPRequest(task);
					qht->setAccessRequest(tb->mService->mService.authData);
					qht->setAccount(tb->mAccount->mAccount.uid, tb->mJsPasswd->vString);
					return task->call(qht, step+1);
				} else if( tb->mService->mService.authType == AuthUser  ) {
					if( !tb->mJsPasswd ) {
						return taskResponse(q, ErrorAuth, "%s. Login error.", codeToMessgae(ErrorAuth));
					}
					if( tb->mAccount->mAccount.authType == AuthExternURL ) {
						if( tb->mAccount->mAccount.authData == NULL ) {
							taskLog(q, LOG_WARNING, "%s. Account authURL is not specified. account=%s,%s.",
									codeToMessgae(ErrorDataConflict),
									tb->mAccount->mAccount.id, tb->mAccount->mAccount.uid);
							return taskResponse(q, ErrorAuth, "%s. Login error.", codeToMessgae(ErrorAuth));
						}
						QnHTTPRequest *qht = new QnHTTPRequest(task);
						qht->setAccessRequest(tb->mAccount->mAccount.authData);
						qht->setAccount(tb->mAccount->mAccount.uid, tb->mJsPasswd->vString);
						return task->call(qht, step+1);
					}
				}

			}
		}
	case 5:
		{
			if( step == 5 ) {
				QnHTTPResult *res	= (QnHTTPResult*)q;
				ErrorCode	code	= res->getResultCode();
				if( code != 0 || res->mStatusCode != 200 ) {
					if( code == 0 ) {
						code = ErrorAuth;
					}
					return taskResponse(q, code, "%s. Login error. statusCode=%d.",
							codeToMessgae(code),
							res->mStatusCode);
				}
			}
			step	= 5;

			if( tb->mService ) {
				if( tb->mService->mService.authType == AuthPasswd ) {
					if( !tb->mJsPasswd ) {
						return taskResponse(q, ErrorAuth, "%s. Login error.", codeToMessgae(ErrorAuth));
					}
					if( strcmp(tb->mJsPasswd->vString, tb->mService->mService.authData) != 0 ) {
						return taskResponse(q, ErrorAuth, "%s. Login error.", codeToMessgae(ErrorAuth));
					}
				}
			}
			if( (tb->mService && tb->mService->mService.authType == AuthUser) || tb->mService == NULL ) {
				if( tb->mAccount->mAccount.authType == AuthPasswd ) {
					if( !tb->mJsPasswd ) {
						return taskResponse(q, ErrorAuth, "%s. Login error.", codeToMessgae(ErrorAuth));
					}
					if( strcmp(tb->mAccount->mAccount.authData, tb->mJsPasswd->vString) != 0) {
						return taskResponse(q, ErrorAuth, "%s. Login error.", codeToMessgae(ErrorAuth));
					}
				}
			}

			if( tb->mJsDevice && tb->mService ) {
				// get device info
				QueryKeyType key;
				key.mId		= NULL;
				key.mName	= tb->mJsUdid->vString;
				QnDBQuery *qn = new QnDBQuery(task);
				qn->queryDevice(&key);
				return task->call(qn, step+1);
			}
		}
	case 6:
		{
			if( step == 6 ) {
				QnDBResult *qn	= (QnDBResult*)q;
				ErrorCode code	= qn->getResultCode();

				DeviceInfo device;
				memset(&device, 0, sizeof(device));
				if( code != ErrorOk ) {
					if( code != ErrorNotFound ) {
						return taskResponse(q, code, "Device check failed. %s", qn->getMessagePtr() );
					}
					tb->mRebuildDevice	= true;
					device.id		= NULL;
				} else {
					tb->mDevice = (ResultDevice*)qn->mResult;
					qn->mResult	= NULL;
					device		= tb->mDevice->mDevice;
				}

				// rebuild client storage ?
				if( !tb->mRebuildDevice ) {
					if( tb->mJsStorageCrypt ) {
						switch(tb->mService->mService.storageCrypt) {
						case CryptAlgorithmNone:
							if( strcmp(tb->mJsStorageCrypt->vString, "none") != 0 )
								tb->mRebuildDevice = true;
							break;
						case CryptAlgorithm3DES:
							if( strcmp(tb->mJsStorageCrypt->vString, "3des") != 0 )
								tb->mRebuildDevice = true;
							break;
						case CryptAlgorithmAES192:
							if( strcmp(tb->mJsStorageCrypt->vString, "aes192") != 0 )
								tb->mRebuildDevice = true;
							break;
						}
					} else {
						tb->mRebuildDevice = true;
					}
				}
				if( !tb->mRebuildDevice ) {
					if( !tb->mJsBlockSize || tb->mJsBlockSize->vInt != tb->mService->mService.storageBlockSize )
						tb->mRebuildDevice = true;
					if( !tb->mJsBlockCount|| tb->mJsBlockCount->vInt != tb->mService->mService.storageBlockCount )
						tb->mRebuildDevice = true;
				}
				if( !tb->mRebuildDevice ) {
					if( tb->mDevice && tb->mDevice->mDevice.accountId && tb->mAccount->mAccount.id ) {
						if( strcmp(tb->mDevice->mDevice.accountId, tb->mAccount->mAccount.id) != 0 )  {
							tb->mRebuildDevice	= true;
						}
					} else {
						tb->mRebuildDevice	= true;
					}
				}

				device.udid				= (char*)tb->mJsUdid->vString;
				if( tb->mJsDevOs )
					device.OS			= (char*)tb->mJsDevOs->vString;
				if( tb->mJsDevOsv )
					device.OSVersion	= (char*)tb->mJsDevOsv->vString;
				if( tb->mJsDevCa )
					device.carrier		= (char*)tb->mJsDevCa->vString;
				if( tb->mJsDevModel )
					device.model		= (char*)tb->mJsDevModel->vString;
				if( tb->mDevice == NULL ) {
					device.storageCrypt		= tb->mService->mService.storageCrypt;
					device.storageBlockSize	= tb->mService->mService.storageBlockSize;
					device.storageBlockCount= tb->mService->mService.storageBlockCount;
					device.storageUse		= 0;
				}
				device.accountId	= tb->mAccount->mAccount.id;
				device.loginTime	= time(NULL);
				device.status		= DeviceConnect;

				// set device info
				QnDBRegister *qreg = new QnDBRegister(task);
				qreg->registDevice(&device);
				taskLog(q, LOG_DEBUG, "device id=%s udid=%s", ((RegistDevice*)qreg->mRegist)->mDevice.id, ((RegistDevice*)qreg->mRegist)->mDevice.udid);
				return task->call(qreg, step+1);
			}
			step	= 6;
		}
	case 7:
		{
			if( step == 7 ) {
				QnDBResult *qn	= (QnDBResult*)q;
				ErrorCode code	= qn->getResultCode();
				if( code != ErrorOk ) {
					return taskResponse(q, ErrorDatabase, "Device registration failed. %s", qn->getMessagePtr() );
				}
				ResultId *rs = (ResultId*)qn->mResult;
				con->setDeviceId(rs->mId);
			}
			step	= 7;

			taskLog(q, LOG_DEBUG, "Login ok. account=%s,%s level=%d service=%s adminId=%s",
					tb->mAccount->mAccount.id, tb->mAccount->mAccount.uid,
					tb->mAccount->mAccount.level,
					tb->mService ? tb->mService->mService.name : "(not service)",
					tb->mService ? tb->mService->mService.adminId : "(not service)");

			taskLog(q, LOG_INFO, "user %s,%s is login.",
					tb->mAccount->mAccount.id, tb->mAccount->mAccount.uid);

			if( tb->mAccount->mAccount.level == AccountUser &&
				strcmp(tb->mService->mService.adminId, tb->mAccount->mAccount.id) == 0 ) {
				con->setAccountLevel(AccountServiceAdmin);
			} else {
				con->setAccountLevel(tb->mAccount->mAccount.level);
			}
			con->setAccountId(tb->mAccount->mAccount.id);
			con->setUserId(tb->mAccount->mAccount.uid);
			if( tb->mService )
				con->setServiceId(tb->mService->mService.id);
			con->setStatus(SessionStatusLogin);

			Account account 	= tb->mAccount->mAccount;
			account.loginTime	= time(NULL);

			QnDBRegister *qn = new QnDBRegister(task);
			QueryKeyType aref;
			aref.mId	= NULL;
			aref.mName	= NULL;
			qn->registAccount(&aref, &account);
			return task->call(qn, step+1);
		}
		break;
	case 8:
		{
			QnDBResult *qn	= (QnDBResult*)q;
			ErrorCode code	= qn->getResultCode();
			if( code != ErrorOk ) {
				taskLog(q, LOG_WARNING, "Login time update was failed. %s", qn->getMessagePtr() );
			}

			pjson::builder jb;
			if( !jb.init(256) ||
				!jb.beginObject() ||
				!jb.addObjectProp("result", 6) ||
				!jb.valueInt(0) ||
				!jb.addObjectProp("sequence", 8) ||
				!jb.valueInt(task->getSequence()) ||
				!jb.addObjectProp("sid", 3) ||
				!jb.valueString(tb->mService->mService.id) ||
				!jb.addObjectProp("heartBeetInterval", 17) ||
				!jb.valueInt(mSentinel->getConf()->heartBeetInterval) ) {
				taskLog(q, LOG_ERR, "json builder failed code=%d", jb.getError());
				return false;
			}
			if( tb->mRebuildDevice ) {
				const char *crypt = "none";
				switch(tb->mService->mService.storageCrypt) {
				case CryptAlgorithmNone:	crypt	= "none";	break;
				case CryptAlgorithm3DES:	crypt	= "3des";	break;
				case CryptAlgorithmAES192:	crypt	= "aes192";	break;
				}

				if( !jb.addObjectProp("storage", 7) ||
					!jb.beginObject() ||
					!jb.addObjectProp("blockSize", 9) ||
					!jb.valueInt(tb->mService->mService.storageBlockSize) ||
					!jb.addObjectProp("blockCount", 10) ||
					!jb.valueInt(tb->mService->mService.storageBlockCount) ||
					!jb.addObjectProp("crypt", 5) ||
					!jb.valueString(crypt) ||
					!jb.endObject() ) {
					taskLog(q, LOG_ERR, "json builder failed code=%d", jb.getError());
					return false;
				}
			}
			if( !jb.endObject() ) {
				taskLog(q, LOG_ERR, "json builder failed code=%d", jb.getError());
				return false;
			}
			return response(q,jb);
		}
		break;
	}
	taskLog(q, LOG_ERR, "unknown step. step=%d.", step);
	return false;
}

}


