/*
 * requester.h
 *
 *  Created on: 2012/07/30
 *      Author: tanaka
 */

#ifndef REQUESTER_H_
#define REQUESTER_H_

#include "../include/sst_types.h"
#include "process.h"
#include <pthread.h>

namespace SST {

enum RequestCommand {
	CMDReqNull		= 0,
	CMDReqAccess	= 1,
	CMDReqGet		= 2,
	CMDReqPost		= 3,

	CMDReqResult	= 100,
};

class QnHTTPRequest : public QueueNode
{
private:
	QnHTTPRequest(const QnHTTPRequest &d);
public:
	QnHTTPRequest(Task *task);
	virtual ~QnHTTPRequest();

	bool	setAccessRequest(const char *url);
	bool	setGetRequest(const char *url);
	bool	setPostRequest(const char *url);
	bool	setAccount(const char *user, const char *pass);

	char *	mURL;
	char *	mAuthType;
	char *	mRealm;
	char *	mUser;
	char *	mPass;
};

class QnHTTPResult : public QnResult
{
private:
	QnHTTPResult(const QnHTTPResult &d);
public:
	QnHTTPResult(Task *task);
	virtual ~QnHTTPResult();

	void setReqResult(ErrorCode code, int statusCode, const char *fmt, ... ) {
		mStatusCode	= statusCode;
	    va_list ap;
	    va_start(ap, fmt);
	    return QnResult::setResult(CMDReqResult, code, fmt, ap);
	}

	int			mStatusCode;
	StdBuffer	mHeader;
	StdBuffer	mBody;
};

typedef struct _cbdata {
	Requester *pThis;
	QueueNode *pQueue;
	QnHTTPResult *pResult;
} cbdata;


class Requester : public Process {
public:
	Requester();
	~Requester();

	virtual bool	configure(Sentinel *obj, Conf *conf);
	virtual void	clear();
	virtual const char *getName() const { return "Requester"; }
	virtual const char *getFuncName(int id);

protected:
	virtual bool	exec(QueueNode *q);
	virtual void	stop(QueueNode *q);

	bool	cmdHttpAccess(QnHTTPRequest *q);
	bool	cmdHttpGet(QnHTTPRequest *q);
	bool	cmdHttpPost(QnHTTPRequest *q);

	static void		connectProc(int fd, short event, void *args);
	static void		recvProc(int fd, short event, void *args);

	Message	*	getResponse();
//	size_t		writeCB(char* ptr, size_t size, size_t nmemb, Task *task);

	static size_t pxWriteCB(char* ptr, size_t size, size_t nmemb, void* data);
	static size_t pxHeaderCB(char* ptr, size_t size, size_t nmemb, void* data);
};

}


#endif /* REQUESTER_H_ */
