/*
 * ssg.h
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */
#ifndef SSG_H_
#define SSG_H_

#if defined(SSG_STATIC)
# define SSG_EXPORT
# define SSG_IMPORT
#else
#if defined(_MSC_VER) // Microsoft
#define SSG_EXPORT __declspec(dllexport)
#define SSG_IMPORT __declspec(dllimport)
#elif defined(_GCC) // GCC
#define SSG_EXPORT __attribute__((visibility("default")))
#define SSG_IMPORT
#else // do nothing and hope for the best?
#define SSG_EXPORT
#define SSG_IMPORT
#pragma warning Unknown dynamic link import/export semantics.
#endif
#endif

#ifdef SSG_EXPORTS
#define SSG_API SSG_EXPORT
#else
#define SSG_API SSG_IMPORT
#endif

#include <stdlib.h>
#include <stdio.h>

namespace ssg {

#ifndef SSG_UNICODE
#ifdef _UNICODE
#	define SSG_UNICODE
#endif
#endif

#ifdef SSG_UNICODE
	typedef unsigned short	CHAR;
#else
	typedef char	CHAR;
#endif

#ifdef SSG_UNICODE
# define ES_T(x) L ## x
#else
# define ES_T(x) x
#endif

typedef size_t			SIZE;
typedef unsigned char	BYTE;
typedef short			SHORT;
typedef int				INT;
typedef unsigned short	USHORT;
typedef unsigned int	UINT;

enum Pixformat {
	SC_HORZ=0,
	SC_VERT=1,
	SC_HORZG2=2,
	SC_HORZG4=3,
};

typedef struct _Rect {
	INT	x;
	INT	y;
	INT	width;
	INT	height;
} Rect;

typedef struct _Point {
	INT x;
	INT	y;
} Point;

class Bitmap {
public:
	class Private;
	class PixIterator {
	public:
		virtual ~PixIterator() {}
		virtual bool setPosition(INT x, INT y) = 0;
		virtual BYTE get() = 0;
	};
	class SegmentIterator {
	public:
		virtual ~SegmentIterator() {}
		virtual bool setPosition(INT x, INT y) = 0;
		virtual bool getPosition(INT &x, INT &y) = 0;
		virtual bool operator==(SegmentIterator &d) = 0;
		virtual bool operator!=(SegmentIterator &d) { return !(*this==d); }
		virtual bool getSegment(BYTE *data) = 0;
		virtual bool setSegment(BYTE *data) = 0;
		virtual bool copySegment(SegmentIterator &d) = 0;
		virtual bool next() = 0;
	};
	class PixMapper {
	public:
		virtual ~PixMapper() {}
		virtual BYTE map(BYTE s) = 0;
	};

	~Bitmap();
	static Bitmap *create(INT width, INT height, Pixformat pf);

	INT			getWidth() const;
	INT			getHeight() const;
	INT			getLineSize() const;
	INT			getHorzSegments() const;
	INT			getVertSegments() const;
	Pixformat	getPixformat() const;
	void *		getBitmap();
	PixIterator *createHorzPixIterator() const;
	PixIterator *createVertPixIterator() const;
	SegmentIterator *createSegIterator() const;
	PixMapper *	createPixMapper(Pixformat pf) const;
	Private *	getPrivate() const;

protected:
	Bitmap();
	Bitmap(const Bitmap &);
	void operator=(const Bitmap&);

	Private *ptr;
};

class Font;

class Glyph {
public:
	class Private;
	~Glyph();
	INT getAscent() const;
	INT	getDescent() const;
	INT getOffset() const;
	INT	getWidth() const;
	const Bitmap *getBitmap() const;
	Private *	getPrivate() const;
	
protected:
	Glyph();
	Glyph(const Glyph &);
	void operator=(const Glyph&);

	Private *ptr;
};

class Font {
public:
	class Private;
	static Font *load(const CHAR *fontFile);
	static Font *loadA(const char *fontFile);
	~Font();

	INT	getAscent() const;
	INT	getDescent() const;
	const Glyph *getGlyph(CHAR c) const;
	Private *	getPrivate() const;

protected:
	Font();
	Font(const Glyph &);
	void operator=(const Font&);

	Private *ptr;
};

class Painter {
public:
	class Private;

	Painter();
	~Painter();

	void		setBitmap(Bitmap *bmp);
	Bitmap *	getBitmap();
	void		clear();
	void		setColor(BYTE c);
	void		fillRect(const Rect *rect);
	void		frameRect(const Rect *rect);
	void		line(const Point *s, const Point *e);
	void		image(const Bitmap *img, const Point *p);
	void		text(const Font *font, const Point *p, const CHAR *str);
	void		textA(const Font *font, const Point *p, const char *str);
	void		textArea(Point &size, const Font *font, const char *str);

protected:
	Painter(const Painter &);
	void operator=(const Painter&);

	Private *ptr;
};



} // ssg

#endif /* SSG_H_ */
