/*
 * bitmap.h
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */

#ifndef BITMAP_H_
#define BITMAP_H_

#include "../include/ssg.h"

namespace ssg {

class ssg::Bitmap::Private {
public:
	Private();
	virtual ~Private();
	virtual bool create(INT width, INT height, Pixformat pf) = 0;
	virtual void clear() = 0;
	virtual PixIterator *createHorzPixIterator() = 0;
	virtual PixIterator *createVertPixIterator() = 0;
	virtual SegmentIterator *createSegIterator() = 0;

	INT			width;
	INT			height;
	INT			fb_width;
	INT			fb_height;
	INT			mb_width;
	INT			mb_height;
	Pixformat	pixformat;
	SIZE		bmp_bytes;
	void *		bmp;
};

class PixMapper1x1 : public Bitmap::PixMapper {
public:
	virtual ~PixMapper1x1() {}
	virtual BYTE map(BYTE s) { return s; }
};
class PixMapper1x2 : public Bitmap::PixMapper {
public:
	virtual ~PixMapper1x2() {}
	virtual BYTE map(BYTE s) { return s*3; }
};
class PixMapper1x4 : public Bitmap::PixMapper {
public:
	virtual ~PixMapper1x4() {}
	virtual BYTE map(BYTE s) { return s*15; }
};
class PixMapper2x1 : public Bitmap::PixMapper {
public:
	virtual ~PixMapper2x1() {}
	virtual BYTE map(BYTE s) { return s ? 1 : 0; }
};
class PixMapper2x4 : public Bitmap::PixMapper {
public:
	virtual ~PixMapper2x4() {}
	virtual BYTE map(BYTE s) { return s * 5; }
};
class PixMapper4x1 : public Bitmap::PixMapper {
public:
	virtual ~PixMapper4x1() {}
	virtual BYTE map(BYTE s) { return s ? 1 : 0; }
};
class PixMapper4x2 : public Bitmap::PixMapper {
public:
	virtual ~PixMapper4x2() {}
	virtual BYTE map(BYTE s) { return s / 5; }
};

} //ssg
#endif /* BITMAP_H_ */
