/*
 * bitmap.cpp
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */
#include "bitmap.h"
#include "bitmap_g2.h"

#include <stdlib.h>
#include <malloc.h>
#include <memory.h>

namespace ssg {

HorzG2Bitmap::HorzG2Bitmap(Bitmap *inst)
{
	this->inst	= inst;
}

bool HorzG2Bitmap::create(INT width, INT height, Pixformat pf)
{
	INT mbw, mbh;
	INT fbw, fbh;
	mbw	= width / 4;
	if( width % 4 != 0 ) mbw++;
	mbh	= height;
	fbw = mbw * 4;
	fbh = mbh;
	SIZE bmp_bytes = mbw * mbh;
	this->width		= width;
	this->height	= height;
	this->fb_width	= fbw;
	this->fb_height	= fbh;
	this->mb_width	= mbw;
	this->mb_height	= mbh;
	this->bmp_bytes	= bmp_bytes;
	this->bmp		= malloc(bmp_bytes);
	clear();
	return true;
}

void HorzG2Bitmap::clear() {
	memset(bmp, 0, bmp_bytes);
}

Bitmap::PixIterator *HorzG2Bitmap::createHorzPixIterator()
{
	return new HorzIterator(this);
}

Bitmap::PixIterator *HorzG2Bitmap::createVertPixIterator()
{
	return new VertIterator(this);
}

Bitmap::SegmentIterator *HorzG2Bitmap::createSegIterator()
{
	return new SegIterator(this);
}

HorzG2Bitmap::HorzIterator::HorzIterator(HorzG2Bitmap *inst)
{
	this->inst = inst;
	setPosition(0,0);
}

bool HorzG2Bitmap::HorzIterator::setPosition(INT x, INT y)
{
	this->x	= x;
	this->y	= y;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	seg	= x / 4;
	bit	= x % 4;
	return true;
}

static const BYTE pmap[] = {0xc0, 0x30, 0x0c, 0x0f};
BYTE HorzG2Bitmap::HorzIterator::get()
{
	BYTE c = (ptr[seg]&pmap[bit])>>((3-bit)*2);
	x++;
	seg	= x / 4;
	bit	= x % 4;
	return c;
}
//
HorzG2Bitmap::VertIterator::VertIterator(HorzG2Bitmap *inst)
{
	this->inst = inst;
	setPosition(0,0);
}

bool HorzG2Bitmap::VertIterator::setPosition(INT x, INT y)
{
	this->x	= x;
	this->y	= y;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	seg		= x / 4;
	mask	= pmap[x % 4];
	shift	= (3-(x % 4))*2;
	return true;
}

BYTE HorzG2Bitmap::VertIterator::get()
{
	BYTE c = (ptr[seg]&mask)>>shift;
	y++;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	return c;
}

//
HorzG2Bitmap::SegIterator::SegIterator(HorzG2Bitmap *inst)
{
	this->inst	= inst;
	this->x		= 0;
	this->y		= 0;
}

HorzG2Bitmap::SegIterator::~SegIterator()
{
}

bool HorzG2Bitmap::SegIterator::setPosition(INT x, INT y)
{
	INT hs = inst->inst->getHorzSegments();
	INT vs = inst->inst->getVertSegments();
	if( x < 0 || hs < x ) return false;
	if( y < 0 || vs < y ) return false;
	this->x		= x;
	this->y		= y;
	return true;
}

bool HorzG2Bitmap::SegIterator::getPosition(INT &x, INT &y)
{
	x = this->x;
	y = this->y;
	return true;
}
bool HorzG2Bitmap::SegIterator::operator==(SegmentIterator &d)
{
	BYTE data0[16];
	BYTE data1[16];
	getSegment(data0);
	d.getSegment(data1);
	for(int i=0; i < 16; i++) {
		if( data0[i] != data1[i] ) return false;
	}
	return true;
}

bool HorzG2Bitmap::SegIterator::getSegment(BYTE *data)
{
	BYTE *ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y * 8 + x;
	for(int i=0; i < 8; i++ ) {
		*data++ = *ptr;
		*data++ = *(ptr+1);
		ptr += inst->mb_width;
	}
	return true;
}

bool HorzG2Bitmap::SegIterator::setSegment(BYTE *data)
{
	BYTE *ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y * 8 + x;
	for(int i=0; i < 8; i++ ) {
		*ptr = *data++;
		*(ptr+1) = *data++;
		ptr += inst->mb_width;
	}
	return true;
}
bool HorzG2Bitmap::SegIterator::copySegment(SegmentIterator &d)
{
	BYTE data[16];
	d.getSegment(data);
	return setSegment(data);
}

bool HorzG2Bitmap::SegIterator::next()
{
	x++;
	if( inst->mb_width <= x ) {
		x = 0;
		y += 8;
		if( inst->height / 8 <= y ) {
			x = 0;
			y = 0;
			return false;
		}
	}
	return true;
}

} // ssg



