/*
 * bitmap.cpp
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */
#include "bitmap.h"
#include "bitmap_g4.h"

#include <stdlib.h>
#include <malloc.h>
#include <memory.h>

namespace ssg {

HorzG4Bitmap::HorzG4Bitmap(Bitmap *inst)
{
	this->inst	= inst;
}

bool HorzG4Bitmap::create(INT width, INT height, Pixformat pf)
{
	INT mbw, mbh;
	INT fbw, fbh;
	mbw	= width / 2;
	if( width % 2 != 0 ) mbw++;
	mbh	= height;
	fbw = mbw * 2;
	fbh = mbh;
	SIZE bmp_bytes = mbw * mbh;
	this->width		= width;
	this->height	= height;
	this->fb_width	= fbw;
	this->fb_height	= fbh;
	this->mb_width	= mbw;
	this->mb_height	= mbh;
	this->bmp_bytes	= bmp_bytes;
	this->bmp		= malloc(bmp_bytes);
	clear();
	return true;
}

void HorzG4Bitmap::clear() {
	memset(bmp, 0, bmp_bytes);
}

Bitmap::PixIterator *HorzG4Bitmap::createHorzPixIterator()
{
	return new HorzIterator(this);
}

Bitmap::PixIterator *HorzG4Bitmap::createVertPixIterator()
{
	return new VertIterator(this);
}

Bitmap::SegmentIterator *HorzG4Bitmap::createSegIterator()
{
	return new SegIterator(this);
}

HorzG4Bitmap::HorzIterator::HorzIterator(HorzG4Bitmap *inst)
{
	this->inst = inst;
	setPosition(0,0);
}

bool HorzG4Bitmap::HorzIterator::setPosition(INT x, INT y)
{
	this->x	= x;
	this->y	= y;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	seg	= x / 2;
	bit	= x % 2;
	return true;
}

static const BYTE pmap[] = {0xf0, 0x0f};
BYTE HorzG4Bitmap::HorzIterator::get()
{
	BYTE c = (ptr[seg]&pmap[bit])>>((1-bit)*4);
	x++;
	seg	= x / 2;
	bit	= x % 2;
	return c;
}
//
HorzG4Bitmap::VertIterator::VertIterator(HorzG4Bitmap *inst)
{
	this->inst = inst;
	setPosition(0,0);
}

bool HorzG4Bitmap::VertIterator::setPosition(INT x, INT y)
{
	this->x	= x;
	this->y	= y;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	seg		= x / 2;
	mask	= pmap[x % 2];
	shift	= (1-(x % 2))*4;
	return true;
}

BYTE HorzG4Bitmap::VertIterator::get()
{
	BYTE c = (ptr[seg]&mask)>>shift;
	y++;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	return c;
}
//
HorzG4Bitmap::SegIterator::SegIterator(HorzG4Bitmap *inst)
{
	this->inst	= inst;
	this->x		= 0;
	this->y		= 0;
}

HorzG4Bitmap::SegIterator::~SegIterator()
{
}

bool HorzG4Bitmap::SegIterator::setPosition(INT x, INT y)
{
	INT hs = inst->inst->getHorzSegments();
	INT vs = inst->inst->getVertSegments();
	if( x < 0 || hs < x ) return false;
	if( y < 0 || vs < y ) return false;
	this->x		= x;
	this->y		= y;
	return true;
}

bool HorzG4Bitmap::SegIterator::getPosition(INT &x, INT &y)
{
	x = this->x;
	y = this->y;
	return true;
}
bool HorzG4Bitmap::SegIterator::operator==(SegmentIterator &d)
{
	BYTE data0[32];
	BYTE data1[32];
	getSegment(data0);
	d.getSegment(data1);
	for(int i=0; i < 32; i++) {
		if( data0[i] != data1[i] ) return false;
	}
	return true;
}

bool HorzG4Bitmap::SegIterator::getSegment(BYTE *data)
{
	BYTE *ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y * 8 + x;
	for(int i=0; i < 8; i++ ) {
		*data++ = *ptr;
		*data++ = *(ptr+1);
		*data++ = *(ptr+2);
		*data++ = *(ptr+3);
		ptr +=  inst->mb_width;
	}
	return true;
}

bool HorzG4Bitmap::SegIterator::setSegment(BYTE *data)
{
	BYTE *ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y * 8 + x;
	for(int i=0; i < 8; i++ ) {
		*ptr 	 = *data++;
		*(ptr+1) = *data++;
		*(ptr+2) = *data++;
		*(ptr+3) = *data++;
		ptr +=  inst->mb_width;
	}
	return true;
}
bool HorzG4Bitmap::SegIterator::copySegment(SegmentIterator &d)
{
	BYTE data[32];
	d.getSegment(data);
	return setSegment(data);
}

bool HorzG4Bitmap::SegIterator::next()
{
	x++;
	if( inst->mb_width <= x ) {
		x = 0;
		y += 8;
		if( inst->height / 8 <= y ) {
			x = 0;
			y = 0;
			return false;
		}
	}
	return true;
}

} // ssg



