/*
 * bitmap.cpp
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */
#include "bitmap.h"
#include "bitmap_h1.h"

#include <syslog.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>

namespace ssg {

HorzBitmap::HorzBitmap(Bitmap *inst)
{
	this->inst	= inst;
}

bool HorzBitmap::create(INT width, INT height, Pixformat pf)
{
	INT mbw, mbh;
	INT fbw, fbh;
	mbw	= width / 8;
	if( width % 8 != 0 ) mbw++;
	mbh	= height;
	fbw = mbw * 8;
	fbh = mbh;
	SIZE bmp_bytes = mbw * mbh;
	this->width		= width;
	this->height	= height;
	this->fb_width	= fbw;
	this->fb_height	= fbh;
	this->mb_width	= mbw;
	this->mb_height	= mbh;
	this->bmp_bytes	= bmp_bytes;
	this->bmp		= malloc(bmp_bytes);
	clear();
	return true;
}

void HorzBitmap::clear() {
	memset(bmp, 0, bmp_bytes);
}

Bitmap::PixIterator *HorzBitmap::createHorzPixIterator()
{
	return new HorzIterator(this);
}

Bitmap::PixIterator *HorzBitmap::createVertPixIterator()
{
	return new VertIterator(this);
}
Bitmap::SegmentIterator *HorzBitmap::createSegIterator()
{
	return new SegIterator(this);
}

HorzBitmap::HorzIterator::HorzIterator(HorzBitmap *inst)
{
	this->inst = inst;
	setPosition(0,0);
}

bool HorzBitmap::HorzIterator::setPosition(INT x, INT y)
{
	this->x	= x;
	this->y	= y;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	seg	= x / 8;
	bit	= x % 8;
	return true;
}

static const BYTE pmap[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};
BYTE HorzBitmap::HorzIterator::get()
{
	BYTE c = (ptr[seg]&pmap[bit])>>(7-bit);
	x++;
	seg	= x / 8;
	bit	= x % 8;
	return c;
}
//
HorzBitmap::VertIterator::VertIterator(HorzBitmap *inst)
{
	this->inst = inst;
	setPosition(0,0);
}

bool HorzBitmap::VertIterator::setPosition(INT x, INT y)
{
	this->x	= x;
	this->y	= y;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	seg		= x / 8;
	mask	= pmap[x % 8];
	shift	= 7 - (x % 8);
	return true;
}

BYTE HorzBitmap::VertIterator::get()
{
	BYTE c = (ptr[seg]&mask)>>shift;
	y++;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	return c;
}
//
HorzBitmap::SegIterator::SegIterator(HorzBitmap *inst)
{
	this->inst	= inst;
	this->x		= 0;
	this->y		= 0;
}

HorzBitmap::SegIterator::~SegIterator()
{
}

bool HorzBitmap::SegIterator::setPosition(INT x, INT y)
{
	INT hs = inst->inst->getHorzSegments();
	INT vs = inst->inst->getVertSegments();
	if( x < 0 || hs < x ) {
		syslog(LOG_ERR, "HorzBitmap::SegIterator::setPosition error x=%d y=%d", x, y);
		return false;
	}
	if( y < 0 || vs < y ) {
		syslog(LOG_ERR, "HorzBitmap::SegIterator::setPosition error x=%d y=%d", x, y);
		return false;
	}
	this->x		= x;
	this->y		= y;
	return true;
}

bool HorzBitmap::SegIterator::getPosition(INT &x, INT &y)
{
	x = this->x;
	y = this->y;
	return true;
}
bool HorzBitmap::SegIterator::operator==(SegmentIterator &d)
{
	BYTE data0[8];
	BYTE data1[8];
	getSegment(data0);
	d.getSegment(data1);

	for(int i=0; i < 8; i++) {
		if( data0[i] != data1[i] ) return false;
	}
	return true;
}

bool HorzBitmap::SegIterator::getSegment(BYTE *data)
{
	BYTE *ptr	= ((BYTE*)inst->bmp) + inst->mb_width * (y * 8) + x;
	for(int i=0; i < 8; i++ ) {
		*data++ = *ptr;
		ptr += inst->mb_width;
	}
	return true;
}

bool HorzBitmap::SegIterator::setSegment(BYTE *data)
{
	BYTE *ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y * 8 + x;
	for(int i=0; i < 8; i++ ) {
		*ptr = *data++;
		ptr += inst->mb_width;
	}
	return true;
}
bool HorzBitmap::SegIterator::copySegment(SegmentIterator &d)
{
	BYTE data[8];
	d.getSegment(data);
	return setSegment(data);
}

bool HorzBitmap::SegIterator::next()
{
	x++;
	INT hs = inst->inst->getHorzSegments();
	if( hs <= x ) {
		syslog(LOG_ERR, "HorzBitmap::SegIterator::next round horz");
		x = hs-1;
	}
	return true;
}

} // ssg



