/*
 * bitmap.cpp
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */
#include "bitmap.h"
#include "bitmap_v1.h"

#include <stdlib.h>
#include <malloc.h>
#include <memory.h>

namespace ssg {

VertBitmap::VertBitmap(Bitmap *inst)
{
	this->inst	= inst;
}

bool VertBitmap::create(INT width, INT height, Pixformat pf)
{
	INT mbw, mbh;
	INT fbw, fbh;
	mbw	= width;
	mbh	= height / 8;
	if( height % 8 != 0 ) mbh++;
	fbw = mbw;
	fbh = mbh * 8;
	SIZE bmp_bytes = mbw * mbh;
	this->width		= width;
	this->height	= height;
	this->fb_width	= fbw;
	this->fb_height	= fbh;
	this->mb_width	= mbw;
	this->mb_height	= mbh;
	this->bmp_bytes	= bmp_bytes;
	this->bmp		= malloc(bmp_bytes);
	clear();
	return true;
}

void VertBitmap::clear() {
	memset(bmp, 0, bmp_bytes);
}

Bitmap::PixIterator *VertBitmap::createHorzPixIterator()
{
	return new HorzIterator(this);
}

Bitmap::PixIterator *VertBitmap::createVertPixIterator()
{
	return new VertIterator(this);
}

Bitmap::SegmentIterator *VertBitmap::createSegIterator()
{
	return new SegIterator(this);
}

VertBitmap::HorzIterator::HorzIterator(VertBitmap *inst)
{
	this->inst = inst;
	setPosition(0,0);
}


bool VertBitmap::HorzIterator::setPosition(INT x, INT y)
{
	this->x	= x;
	this->y	= y;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	seg	= x / 8;
	bit	= x % 8;
	return true;
}

static const BYTE pmap[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};
BYTE VertBitmap::HorzIterator::get()
{
	BYTE c = (ptr[seg]&pmap[bit])>>(7-bit);
	x++;
	seg	= x / 8;
	bit	= x % 8;
	return c ? 0xff : 0x00;
}
//
VertBitmap::VertIterator::VertIterator(VertBitmap *inst)
{
	this->inst = inst;
	setPosition(0,0);
}

bool VertBitmap::VertIterator::setPosition(INT x, INT y)
{
	this->x	= x;
	this->y	= y;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	seg		= x / 8;
	mask	= pmap[x % 8];
	shift	= 7 - (x % 8);
	return true;
}

BYTE VertBitmap::VertIterator::get()
{
	BYTE c = (ptr[seg]&mask)>>shift;
	y++;
	ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y;
	return c ? 0xff : 0x00;
}
//
VertBitmap::SegIterator::SegIterator(VertBitmap *inst)
{
	this->inst	= inst;
	this->x		= 0;
	this->y		= 0;
}

VertBitmap::SegIterator::~SegIterator()
{
}

bool VertBitmap::SegIterator::setPosition(INT x, INT y)
{
	INT hs = inst->inst->getHorzSegments();
	INT vs = inst->inst->getVertSegments();
	if( x < 0 || hs < x ) return false;
	if( y < 0 || vs < y ) return false;
	this->x		= x;
	this->y		= y;
	return true;
}

bool VertBitmap::SegIterator::getPosition(INT &x, INT &y)
{
	x = this->x;
	y = this->y;
	return true;
}
bool VertBitmap::SegIterator::operator==(SegmentIterator &d)
{
	BYTE data0[8];
	BYTE data1[8];
	getSegment(data0);
	d.getSegment(data1);
	for(int i=0; i < 8; i++) {
		if( data0[i] != data1[i] ) return false;
	}
	return true;
}

bool VertBitmap::SegIterator::getSegment(BYTE *data)
{
	BYTE *ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y * 8 + x;
	for(int i=0; i < 8; i++ )
		*data++ = *ptr++;
	return true;
}

bool VertBitmap::SegIterator::setSegment(BYTE *data)
{
	BYTE *ptr	= ((BYTE*)inst->bmp) + inst->mb_width * y * 8 + x;
	for(int i=0; i < 8; i++ )
		*ptr++ = *data++;
	return true;
}
bool VertBitmap::SegIterator::copySegment(SegmentIterator &d)
{
	BYTE data[8];
	d.getSegment(data);
	return setSegment(data);
}

bool VertBitmap::SegIterator::next()
{
	x++;
	if( inst->mb_width <= x ) {
		x = 0;
		y += 8;
		if( inst->height / 8 <= y ) {
			x = 0;
			y = 0;
			return false;
		}
	}
	return true;
}

} // ssg



