/*
 * bitmap.h
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */

#ifndef BITMAP_V1_H_
#define BITMAP_V1_H_

#include "../include/ssg.h"
#include "bitmap.h"

namespace ssg {

class VertBitmap : public ssg::Bitmap::Private {
public:
	class HorzIterator : public Bitmap::PixIterator {
	public:
		HorzIterator(VertBitmap *inst);
		virtual ~HorzIterator() {}
		virtual bool setPosition(INT x, INT y);
		virtual BYTE get();

		VertBitmap *inst;
		INT	x;
		INT y;
		INT	bit;
		INT seg;
		BYTE *ptr;
	};
	class VertIterator : public Bitmap::PixIterator {
	public:
		VertIterator(VertBitmap *inst);
		virtual ~VertIterator() {}
		virtual bool setPosition(INT x, INT y);
		virtual BYTE get();

		VertBitmap *inst;
		INT	x;
		INT	y;
		INT	shift;
		BYTE mask;
		BYTE seg;
		BYTE *ptr;
	};

	class SegIterator : public Bitmap::SegmentIterator {
	public:
		SegIterator(VertBitmap *inst);
		virtual ~SegIterator();
		virtual bool setPosition(INT x, INT y);
		virtual bool getPosition(INT &x, INT &y);
		virtual bool operator==(SegmentIterator &d);
		virtual bool getSegment(BYTE *data);
		virtual bool setSegment(BYTE *data);
		virtual bool copySegment(SegmentIterator &d);
		virtual bool next();

		VertBitmap *inst;
		INT	x;
		INT	y;
	};

	VertBitmap(Bitmap *inst);
	virtual ~VertBitmap() {}
	virtual bool create(INT width, INT height, Pixformat pf);
	virtual void clear();
	virtual Bitmap::PixIterator *createHorzPixIterator();
	virtual Bitmap::PixIterator *createVertPixIterator();
	virtual Bitmap::SegmentIterator *createSegIterator();

	Bitmap *inst;
};

} //ssg
#endif /* BITMAP_V1_H_ */
