/*
 * font.cpp
 *
 *  Created on: 2012/02/07
 *      Author: tanaka
 */

#include "font.h"
#include "glyph.h"
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
//#include <.h>
#include <sys/stat.h>
#include <stdio.h>
#include <syslog.h>
#ifdef SSG_UNICODE
#include <iconv.h>
#endif

namespace ssg {

Font::Private::Private()
{
	ascent	= 0;
	descent	= 0;
	buff	= NULL;
	fp		= NULL;
}

Font::Private::~Private()
{
	if( fp ) fclose(fp);
	if( buff ) free(buff);
}

bool Font::Private::load(const CHAR *fontFile)
{
	char fn[256];
	wcstombs(fn, (wchar_t*)fontFile, 256);
	return loadA(fn);
}

bool Font::Private::loadA(const char *fontFile)
{
	struct stat st;
	if( stat(fontFile, &st) != 0 ) return NULL;
	this->buff = (BYTE*)malloc(st.st_size);
	FILE *fp = fopen(fontFile, "rb");
	fread(this->buff, 1, st.st_size, fp);
	fclose(fp);

	unsigned short *mp = (unsigned short *)this->buff;
	this->ascent = *mp++;
	this->descent = *mp++;

	int chs=0;
	while( *mp ) {
		unsigned short code = *mp++;
		unsigned short chars = *mp++;
		chs += chars;
		unsigned int *offp = (unsigned int*)mp;
		mp = (unsigned short*)(offp+chars);
	}
	syslog(LOG_INFO, "font %s: ascent=%d descent=%d %d chars loaded", fontFile, ascent, descent, chs);
	return true;
}

const Bitmap *Font::Private::getMetrics(BBX &bbx, CHAR c) const
{
	unsigned short *mp = (unsigned short *)this->buff;
	mp += 2; // ascent descent
	while( *mp ) {
		unsigned short code = *mp++;
		unsigned short chars = *mp++;
		unsigned int *offp = (unsigned int*)mp;
		if( c < code ) break;
		if( code <= c && c < code+chars ) {
			offp += c-code;
			if( *offp ) {
				char *p = (char*)(buff+(*offp));
				bbx.w = *p++;
				bbx.h = *p++;
				bbx.offx = *p++;
				bbx.offy = *p++;
				bbx.dw	= *p++;
				unsigned char *pat = (unsigned char *)p;
				int line = bbx.w/8;
				if( bbx.w%8 ) line++;
				int y=0;
				Bitmap *bmp = Bitmap::create(bbx.w, bbx.h, SC_HORZ);
				BYTE *ptr = (BYTE*)bmp->getBitmap();
				for( y = 0; y < bbx.h; y++ ) {
					for(int x=0; x < line; x++) {
						*ptr++ = *pat++;
					}
				}
				return bmp;
			}
			break;
		}
		mp = (unsigned short*)(offp+chars);
	}

	return NULL;
}

Font::Font()
{
	ptr = new Private();
}

Font::~Font()
{
	if( ptr ) delete ptr;
}

Font *Font::load(const CHAR *fontFile)
{
	Font *fp = new Font();
	if( !fp->ptr->load(fontFile) ) {
		delete fp;
		return NULL;
	}
	return fp;
}

Font *Font::loadA(const char *fontFile)
{
	Font *fp = new Font();
	if( !fp->ptr->loadA(fontFile) ) {
		delete fp;
		return NULL;
	}
	return fp;
/*
 *
 	iconv_t ic;
	const char *in_ptr  = fontFile;
	size_t in_size	= strlen(fontFile)+1;
	wchar_t out_buf[1024];
	wchar_t *out_ptr = out_buf;
	size_t out_size	= sizeof(out_buf);

	ic = iconv_open("UTF16//TRANSLIT", "UTF8");
	iconv(ic, (char**)&in_ptr, &in_size, (char**)&out_ptr, &out_size);
	iconv_close(ic);

	return load(out_buf);
	*/
}

INT	Font::getAscent() const
{
	if( ptr )
		return ptr->ascent;
	return 0;
}

INT	Font::getDescent() const
{
	if( ptr )
		return ptr->descent;
	return 0;
}

const Glyph *Font::getGlyph(CHAR c) const
{
	if( ptr ) {
		BBX bbx;
		const Bitmap *bmp = ptr->getMetrics(bbx, c);
		if( !bmp ) return NULL;

		INT ascent;
		INT descent;
		INT offset;
		if( bbx.offy < 0 ) {
			ascent	= bbx.h + bbx.offy;
			descent	= -bbx.offy;
		} else {
			ascent	= bbx.h + bbx.offy;
			descent	= 0;
		}
		offset = bbx.offx;
		const Glyph *g = Glyph::Private::create(bmp, ascent, descent, offset, bbx.dw);
		return g;
	}
	return NULL;
}

Font::Private * Font::getPrivate() const
{
	return ptr;
}

} // ssg
