/*
 * glyph.cpp
 *
 *  Created on: 2012/02/07
 *      Author: tanaka
 */

#include "glyph.h"
#include "font.h"
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
//#include <.h>
#include <sys/stat.h>
#include <stdio.h>

namespace ssg {

Glyph::Glyph()
{
	ptr = NULL;
}

Glyph::~Glyph()
{
	if( ptr )
		delete ptr;
}

INT Glyph::getAscent() const
{
	if( ptr )
		return ptr->getAscent();
	return 0;
}
INT	Glyph::getDescent() const
{
	if( ptr )
		return ptr->getDescent();
	return 0;
}
INT Glyph::getOffset() const
{
	if( ptr )
		return ptr->getOffset();
	return 0;
}

INT	Glyph::getWidth() const
{
	if( ptr )
		return ptr->getCellWidth();
	return 0;
}

const Bitmap *Glyph::getBitmap() const
{
	if( ptr )
		return ptr->getBitmap();
	return NULL;
}

Glyph::Private * Glyph::getPrivate() const
{
	return ptr;
}

} // ssg




