/*
 * glyph.h
 *
 *  Created on: 2012/02/07
 *      Author: tanaka
 */

#ifndef GLYPH_H_
#define GLYPH_H_

#include "../include/ssg.h"
#include <stdio.h>

namespace ssg {

class ssg::Glyph::Private {
public:
	static const Glyph *create(const Bitmap *bmp, INT ascent, INT descent, INT offset, INT wd) {
		Glyph *g = new Glyph();
		g->ptr = new Private(bmp, ascent, descent, offset, wd);
		return g;
	}
	Private(const Bitmap *bmp, INT ascent, INT descent, INT offset, INT wd) {
		this->bmp		= bmp;
		this->ascent	= ascent;
		this->descent	= descent;
		this->offset	= offset;
		this->height	= ascent + descent + offset;
		this->width		= wd;
	}
	~Private() {
		delete bmp;
	}
	INT getAscent() const { return ascent; }
	INT	getDescent() const { return descent; }
	INT getOffset() const { return offset; }
	INT getCellHeight() const { return height; }
	INT getCellWidth() const { return width; }
	const Bitmap *getBitmap() const { return bmp; }

	const Bitmap *bmp;
	INT		ascent;
	INT		descent;
	INT		offset;
	INT		height;
	INT		width;
};

} // ssg

#endif /* GLYPH_H_ */
