/*
 * painter.cpp
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */
#include "painter.h"
#include "painter_h1.h"
#include "painter_v1.h"
#include "painter_g2.h"
#include "painter_g4.h"
#include "bitmap.h"

#include <syslog.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <math.h>
#ifdef SSG_UNICODE
#include <iconv.h>
#endif

namespace ssg {

Painter::Painter()
{
	ptr = NULL;
}

Painter::~Painter()
{
	delete ptr;
}

void Painter::setBitmap(Bitmap *bmp)
{
	if( !bmp ) {
		if( ptr ) delete ptr;
		ptr = NULL;
		return;
	}
	if( ptr ) {
		if( ptr->getPixformat() != bmp->getPixformat() ) {
			if( ptr ) delete ptr;
			ptr = NULL;
		}
	}
	if( ptr == NULL ) {
		if( bmp->getPixformat() == SC_HORZ ) {
			ptr = new HorzPainter();
		} else if( bmp->getPixformat() == SC_VERT ){
			ptr = new VertPainter();
		} else if( bmp->getPixformat() == SC_HORZG2 ) {
			ptr = new HorzG2Painter();
		} else if( bmp->getPixformat() == SC_HORZG4 ) {
			ptr = new HorzG4Painter();
		} else {
			return;
		}
	}
	ptr->setBitmap(bmp);
}

Bitmap *Painter::getBitmap()
{
	if( ptr )
		return ptr->getBitmap();
	return NULL;
}

void Painter::clear()
{
	if( ptr )
		ptr->clear();
}
void Painter::setColor(BYTE c)
{
	if( ptr )
		ptr->setColor(c);
}
void Painter::fillRect(const Rect *rect)
{
	if( ptr )
		ptr->fillRect(rect);
}
void Painter::frameRect(const Rect *rect)
{
	if( ptr ) {
		Point p0, p1;
		p0.x	= rect->x;
		p0.y	= rect->y;
		p1.x	= rect->x + rect->width - 1;
		p1.y	= rect->y;
		ptr->line(&p0, &p1);
		p0.y	= rect->y + rect->height - 1;
		p1.y	= p0.y;
		ptr->line(&p0, &p1);
		p0.y	= rect->y;
		p1.x	= rect->x;
		ptr->line(&p0, &p1);
		p0.x	= rect->x + rect->width - 1;
		p1.x	= p0.x;
		ptr->line(&p0, &p1);
	}
}
void Painter::line(const Point *s, const Point *e)
{
	if( ptr )
		ptr->line(s, e);
}
void Painter::image(const Bitmap *img, const Point *p)
{
	if( ptr )
		ptr->image(img, p);
}

void Painter::text(const Font *font, const Point *p, const CHAR *str)
{
	if( ptr )
		ptr->text(font, p, str);
}

void  Painter::textA(const Font *font, const Point *p, const char *str)
{
	const char *in_ptr  = str;
	size_t in_size	= strlen(str)+1;
	unsigned wchar_t out_buf[1024];
	unsigned wchar_t *out_ptr = out_buf;
	size_t out_size	= sizeof(out_buf);

	iconv_t ic = iconv_open("UTF16LE", "UTF-8");
	int cn = iconv(ic,(char**)&in_ptr, &in_size, (char**)&out_ptr, &out_size);
	iconv_close(ic);

	if( cn == -1 ) {
		syslog(LOG_INFO, "conv error");
		return;
	}
	char dmp[64*6];
	int i;
	int cv_size = sizeof(out_buf)-out_size;
	unsigned char *px = (unsigned char *)out_buf;
	for(i=0; i < cv_size && i < 64; i++ ) {
		sprintf(&dmp[i*3], "%2.2x ", *px++);
	}
	text(font, p, (const CHAR *)out_buf);
}

void  Painter::textArea(Point &size, const Font *font, const char *str)
{
	size.x	= 0;
	size.y	= font->getAscent()+font->getDescent();
	while(str) {
		CHAR c = *str++;
		const Glyph *g = font->getGlyph(c);
		if( g ) {
			size.x += g->getWidth();
		} else {
			syslog(LOG_INFO, "char error %4.4x", c);
		}
	}
}

} // ssg
