/*
 * painter.h
 *
 *  Created on: 2012/02/03
 *      Author: tanaka
 */

#ifndef PAINTER_H_
#define PAINTER_H_

#include "../include/ssg.h"

namespace ssg {

class ssg::Painter::Private
{
public:
	Private() { bmp=NULL; }
	virtual ~Private() {}

	Bitmap * bmp;

	void 	setBitmap(Bitmap *bmp) {
		this->bmp = bmp;
	}
	Bitmap *getBitmap() {
		return bmp;
	}
	
	virtual Pixformat getPixformat() = 0;

	virtual void	clear() = 0;
	virtual void	setColor(BYTE c) = 0;
	virtual void 	fillRect(const Rect *rect) = 0;
	virtual void	line(const Point *s, const Point *e) = 0;
	virtual void	image(const Bitmap *img, const Point *p) = 0;
	virtual void	text(const Font *font, const Point *p, const CHAR *str) = 0;
};

} // ssg

#endif /* PAINTER_H_ */
