/*
 * painter.cpp
 *
 *  Created on: 2012/02/24
 *      Author: tanaka
 */
#include "painter.h"
#include "bitmap.h"
#include "painter_g2.h"
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <math.h>

namespace ssg {

static const unsigned char lmap[] = {0xff, 0x3f, 0x0f, 0x03, 0x00};
static const unsigned char rmap[] = {0x00, 0xc0, 0xf0, 0xfc, 0xff};
static const unsigned char pmap[] = {0x3f, 0xcf, 0xf3, 0xfc};

void HorzG2Painter::clear()
{
	Bitmap::Private *bp = bmp->getPrivate();
	memset(bp->bmp, 0, bp->bmp_bytes);
}

void HorzG2Painter::setColor(BYTE c)
{
	color = c;
}

void HorzG2Painter::fillRect(const Rect *rect)
{
	Bitmap::Private *bp = bmp->getPrivate();
	Rect r = *rect;
	if( r.x < 0 ) { r.width  -= r.x; r.x = 0; }
	if( r.y < 0 ) { r.height -= r.y; r.y = 0; }
	if( bp->width < r.x + r.width )  r.width  = bp->fb_width  - r.x;
	if( bp->fb_height < r.y + r.height ) r.height = bp->fb_height - r.y;
	if( r.width <= 0 || r.height <= 0 ) return;
	INT sx = r.x / 4;
	INT sb = r.x % 4;
	if( sb ) sx += 1;
	INT ex = (r.x + r.width) / 4;
	INT eb = (r.x + r.width) % 4;
	BYTE smp = 0;
	BYTE emp = 0;
	if( sb ) {
		smp = lmap[sb];
	}
	if( eb ) {
		emp = rmap[eb];
	}
	BYTE smk = ~smp;
	BYTE emk = ~emp;
	BYTE col = (color << 6)|(color << 4)|(color << 2)|color;
	BYTE *lp = ((BYTE*)bp->bmp) + bp->mb_width * r.y;
	for(INT y=0; y<r.height; y++) {
		BYTE *xp = lp + sx;
		if( sb ) *(xp-1) = (*(xp-1)&smk) | (smp&col);
		for(INT x=sx; x<ex;x++) {
			*xp++ = col;
		}
		if( eb ) *xp = (*xp&emk) | (emp&col);
		lp +=  bp->mb_width;
	}
}

void HorzG2Painter::horzLine(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	INT sx;
	INT ex;
	if( s->x < e->x ) {
		sx = s->x;
		ex = e->x;
	} else {
		ex = s->x;
		sx = e->x;
	}
	INT sb = sx / 4;
	INT sm = sx % 4;
	INT eb = ex / 4;
	INT em = ex % 4;
	BYTE smp = 0;
	BYTE emp = 0;
	if( sm ) {
		smp = lmap[sm];
	}
	if( em ) {
		emp = rmap[em];
	}
	BYTE smk = ~smp;
	BYTE emk = ~emp;
	BYTE col = (color << 6)|(color << 4)|(color << 2)|color;
	BYTE *lp = ((BYTE*)bp->bmp) + bp->mb_width * s->y;
	BYTE *xp = lp + sb;
	if( sm ) {
		*(xp-1) = ((*xp-1)&smk) | (col&smp);
		xp++; sb++;
	}
	for(INT x = sb; x <= eb; x++) {
		*xp++ = col;
	}
	if( em ) *xp = (*xp&emk) | (col&emp);
}

void HorzG2Painter::vertLine(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	INT sy;
	INT ey;
	if( s->y < e->y ) {
		sy	= s->y;
		ey	= e->y;
	} else {
		sy	= e->y;
		ey	= s->y;
	}
	INT sx = s->x / 4;
	INT sb = s->x % 4;
	BYTE pm = color << ((3-sb)*2);
	BYTE pmk = ~(0x03 << ((3-sb)*2));
	BYTE *xp = ((BYTE*)bp->bmp) + bp->mb_width * sy + sx;
	for(INT y = sy; y <= ey; y++ ) {
		*xp = (*xp&pmk)|pm;
		xp += bp->mb_width;
	}
}

void HorzG2Painter::line(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	Point sp = *s;
	Point ep = *e;
	if( sp.x == ep.x && sp.y == ep.y ) return;
	if( sp.x < 0 && ep.x < 0 ) return;
	if( sp.x > bp->width && ep.y > bp->width ) return;
	if( sp.y < 0 && ep.y < 0 ) return;
	if( sp.y > bp->height && ep.y > bp->height ) return;

	if( sp.y == ep.y ) {
		if( sp.x < 0 ) sp.x = 0;
		if( ep.x > bp->width ) ep.x = bp->width;
		horzLine(&sp, &ep);
		return;
	}
	if( sp.x == ep.x ) {
		if( sp.y < 0 ) sp.y = 0;
		if( ep.y > bp->height ) ep.y = bp->height;
		vertLine(&sp, &ep);
		return;
	}

	int ay = sp.y < ep.y ? 1 : -1;
	int ax = sp.x < ep.x ? 1 : -1;
	int py = sp.y;
	int px = sp.x;
	float m = ((float)ep.y-(float)sp.y)/((float)ep.x-(float)sp.x);
	float ea = 0;
	BYTE *xpl = ((BYTE*)bp->bmp) + bp->mb_width * py;
	if( abs(m) <= 1.0 ) {
		while(px != ep.x) {
			if( 0 <= px && px < bp->width &&
				0 <= py && py < bp->height ) {
				int bx = px / 4;
				int mx = px % 4;
				BYTE pm = color << ((3-mx)*2);
				BYTE pmk = ~(0x03 << ((3-mx)*2));
				BYTE *xp = xpl + bx;
				*xp = (*xp&pmk) | pm;
			}
			px += ax;
			ea += m;
			if( (ea < 0.0 && ea <= -0.5) || (ea > 0.0 && ea >= 0.5) ) {
				ea	-= ay;
				py	+= ay;
				xpl = ((BYTE*)bp->bmp) + bp->mb_width * py;
			}
		}
	} else {
		m = 1.0/m;
		while(py != ep.y) {
			if( 0 <= px && px < bp->width &&
				0 <= py && py < bp->height ) {
				int bx = px / 2;
				int mx = px % 2;
				BYTE pm = color << ((3-mx)*2);
				BYTE pmk = ~(0x03 << ((3-mx)*2));
				BYTE *xp = xpl + bx;
				*xp = (*xp&pmk) | pm;
			}
			py += ay;
			xpl = ((BYTE*)bp->bmp) + bp->mb_width * py;
			ea += m;
			if( (ea < 0.0 && ea <= -0.5) || (ea > 0.0 && ea >= 0.5) ) {
				ea	-= ax;
				px	+= ax;
			}
		}
	}
}

void HorzG2Painter::image(const Bitmap *img, const Point *p)
{
	Bitmap::Private *dp = bmp->getPrivate();
	Bitmap::Private *sp = img->getPrivate();
	
	if( sp->width == 0 || sp->height == 0 ) return;
	if( dp->width == 0 || dp->height == 0 ) return;
	int put_x = p->x;
	int put_y = p->y;
	int put_bytes = put_x / 4;
	int put_frags = put_x % 4;
	Bitmap::PixIterator *pix = img->createHorzPixIterator();
	Bitmap::PixMapper *pmx = img->createPixMapper(SC_HORZG2);

	for(int sy = 0; sy < sp->height; sy++) {
		pix->setPosition(0, sy);
		if( 0 <= (put_y+sy) && (put_y+sy) < dp->height ) {
			BYTE src_img = pmx->map(pix->get());
			BYTE *put_base = ((BYTE*)dp->bmp) + dp->mb_width * (put_y+sy) + put_bytes;
			for(int sx = 0; sx < sp->width && (sx+put_bytes) < dp->mb_width; sx++) {
				BYTE *put_pat = put_base+(sx/4);
				BYTE mask	= pmap[(put_frags+sx)%4];
				BYTE shift	= 3-((put_frags+sx)%4)*2;
				BYTE dst_img = (*put_pat & mask) | (src_img << shift);
				*put_pat	= dst_img;
				src_img = pmx->map(pix->get());
			}
		}
	}
}

void HorzG2Painter::text(const Font *font, const Point *p, const CHAR *str)
{
	Bitmap::Private *dp = bmp->getPrivate();
	Point bp;
	bp.y = font->getAscent();
	bp.x = 0;
	if( p->y + font->getDescent() < 0 ) return;
	if( p->y - font->getAscent() > dp->height ) return;
	Point pt = *p;
	pt.x += bp.x;
	pt.y += bp.y;
	while(*str) {
		CHAR c = *str++;
		const Glyph *g = font->getGlyph(c);
		if( g ) {
			Point cp = pt;
			cp.y -= g->getAscent();
			cp.x += g->getOffset();
			const Bitmap *bmp = g->getBitmap();
			image(bmp, &cp);
			pt.x += g->getWidth();
		}
	}
}


} // ssg
