/*
 * painter.h
 *
 *  Created on: 2012/02/24
 *      Author: tanaka
 */

#ifndef PAINTER_G2_H_
#define PAINTER_G2_H_

#include "../include/ssg.h"
#include "painter.h"

namespace ssg {

class HorzG2Painter : public ssg::Painter::Private
{
public:
	HorzG2Painter() {
		color = 0x03;
	}
	virtual ~HorzG2Painter() {}
	
	virtual Pixformat getPixformat() { return SC_HORZG2; }

	virtual void	clear();
	virtual void	setColor(BYTE c);
	virtual void 	fillRect(const Rect *rect);
	virtual void	line(const Point *s, const Point *e);
	virtual void	image(const Bitmap *img, const Point *p);
	virtual void	text(const Font *font, const Point *p, const CHAR *str);

	void horzLine(const Point *s, const Point *e);
	void vertLine(const Point *s, const Point *e);
	BYTE color;
};

} // ssg

#endif /* PAINTER_G2_H_ */
