/*
 * painter.cpp
 *
 *  Created on: 2012/02/24
 *      Author: tanaka
 */
#include "painter.h"
#include "bitmap.h"
#include "painter_h1.h"
#include <syslog.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <math.h>

namespace ssg {

static const unsigned char lmap[] = {0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00};
static const unsigned char rmap[] = {0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff};
static const unsigned char pmap[] = {0x7f, 0xbf, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xfe};
void HorzPainter::clear()
{
	Bitmap::Private *bp = bmp->getPrivate();
	memset(bp->bmp, 0, bp->bmp_bytes);
}

void HorzPainter::fillRect(const Rect *rect)
{
	Bitmap::Private *bp = bmp->getPrivate();
	Rect r = *rect;
	if( r.x < 0 ) { r.width  -= r.x; r.x = 0; }
	if( r.y < 0 ) { r.height -= r.y; r.y = 0; }
	if( bp->width < r.x + r.width )  r.width  = bp->fb_width  - r.x;
	if( bp->fb_height < r.y + r.height ) r.height = bp->fb_height - r.y;
	if( r.width <= 0 || r.height <= 0 ) return;
	INT sx = r.x / 8;
	INT sb = r.x % 8;
	if( sb ) sx += 1;
	INT ex = (r.x + r.width) / 8;
	INT eb = (r.x + r.width) % 8;
	BYTE sm = 0;
	BYTE em = 0;
	if( sb ) {
		sm = lmap[sb];
	}
	if( eb ) {
		em = rmap[eb];
	}
	BYTE *lp = ((BYTE*)bp->bmp) + bp->mb_width * r.y;
	for(INT y=0; y<r.height; y++) {
		BYTE *xp = lp + sx;
		if( sb ) *(xp-1) = sm;
		for(INT x=sx; x<ex;x++) {
			*xp++ = 0xff;
		}
		if( eb ) *xp = em;
		lp +=  bp->mb_width;
	}
}

void HorzPainter::horzLine(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	INT sx;
	INT ex;
	if( s->x < e->x ) {
		sx = s->x;
		ex = e->x;
	} else {
		ex = s->x;
		sx = e->x;
	}
	INT sb = sx / 8;
	INT sm = sx % 8;
	INT eb = ex / 8;
	INT em = ex % 8;
	BYTE smp = 0;
	BYTE emp = 0;
	if( sm ) {
		smp = lmap[sm];
	}
	if( em ) {
		emp = rmap[em];
	}
	BYTE *lp = ((BYTE*)bp->bmp) + bp->mb_width * s->y;
	BYTE *xp = lp + sb;
	if( sm ) {
		*(xp-1) = smp;
		xp++; sb++;
	}
	for(INT x = sb; x < eb; x++) {
		*xp++ = 0xff;
	}
	if( em ) *xp = emp;
}

void HorzPainter::vertLine(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	INT sy;
	INT ey;
	if( s->y < e->y ) {
		sy	= s->y;
		ey	= e->y;
	} else {
		sy	= e->y;
		ey	= s->y;
	}
	INT sx = s->x / 8;
	INT sb = s->x % 8;
	BYTE pm = 1<<(7-sb);
	BYTE *xp = ((BYTE*)bp->bmp) + bp->mb_width * sy + sx;
	for(INT y = sy; y <= ey; y++ ) {
		*xp = *xp|pm;
		xp += bp->mb_width;
	}
}

void HorzPainter::line(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	Point sp = *s;
	Point ep = *e;
	if( sp.x == ep.x && sp.y == ep.y ) return;
	if( sp.x < 0 && ep.x < 0 ) return;
	if( sp.x > bp->width && ep.y > bp->width ) return;
	if( sp.y < 0 && ep.y < 0 ) return;
	if( sp.y > bp->height && ep.y > bp->height ) return;

//	if( sp.x > ep.x ) {
	//	sp = *e;
	//	ep = *s;
//	}
	if( sp.y == ep.y ) {
		if( sp.x < 0 ) sp.x = 0;
		if( ep.x > bp->width ) ep.x = bp->width;
		horzLine(&sp, &ep);
		return;
	}
	if( sp.x == ep.x ) {
		if( sp.y < 0 ) sp.y = 0;
		if( ep.y > bp->height ) ep.y = bp->height;
		vertLine(&sp, &ep);
		return;
	}

	int ay = sp.y < ep.y ? 1 : -1;
	int ax = sp.x < ep.x ? 1 : -1;
	int py = sp.y;
	int px = sp.x;
	float m = ((float)ep.y-(float)sp.y)/((float)ep.x-(float)sp.x);
	float ea = 0;
	BYTE *xpl = ((BYTE*)bp->bmp) + bp->mb_width * py;
	if( abs(m) <= 1.0 ) {
		while(px != ep.x) {
			if( 0 <= px && px < bp->width &&
				0 <= py && py < bp->height ) {
				int bx = px / 8;
				int mx = px % 8;
				BYTE *xp = xpl + bx;
				*xp = *xp | (1<<(7-mx));
			}
			px += ax;
			ea += m;
			if( (ea < 0.0 && ea <= -0.5) || (ea > 0.0 && ea >= 0.5) ) {
				ea	-= ay;
				py	+= ay;
				xpl = ((BYTE*)bp->bmp) + bp->mb_width * py;
			}
		}
	} else {
		m = 1.0/m;
		while(py != ep.y) {
			if( 0 <= px && px < bp->width &&
				0 <= py && py < bp->height ) {
				int bx = px / 8;
				int mx = px % 8;
				BYTE *xp = xpl + bx;
				*xp = *xp | (1<<(7-mx));
			}
			py += ay;
			xpl = ((BYTE*)bp->bmp) + bp->mb_width * py;
			ea += m;
			if( (ea < 0.0 && ea <= -0.5) || (ea > 0.0 && ea >= 0.5) ) {
				ea	-= ax;
				px	+= ax;
			}
		}
	}
}

void HorzPainter::image(const Bitmap *img, const Point *p)
{
	Bitmap::Private *dp = bmp->getPrivate();
	Bitmap::Private *sp = img->getPrivate();
	
	if( sp->width == 0 || sp->height == 0 ) return;
	if( dp->width == 0 || dp->height == 0 ) return;
	int put_x = p->x;
	int put_y = p->y;
	int put_bytes = put_x / 8;
	int put_frags = put_x % 8;
	Bitmap::PixIterator *pix = img->createHorzPixIterator();
	Bitmap::PixMapper *pmx = img->createPixMapper(SC_HORZ);

	for(int sy = 0; sy < sp->height; sy++) {
		pix->setPosition(0, sy);
		if( 0 <= (put_y+sy) && (put_y+sy) < dp->height ) {
			BYTE src_img = pmx->map(pix->get());
			BYTE *put_base = ((BYTE*)dp->bmp) + dp->mb_width * (put_y+sy);
			for(int sx = 0; sx < sp->width && (put_x+sx) / 8 < dp->mb_width; sx++) {
				BYTE *put_pat = put_base + (put_x+sx) / 8;
				BYTE mask	= pmap[(put_x+sx)%8];
				BYTE shift	= 7-((put_x+sx)%8);
				BYTE dst_img = (*put_pat & mask) | ((src_img << shift) & (~mask));
				*put_pat	= dst_img;
				src_img = pmx->map(pix->get());
			}
		}
	}
}

void HorzPainter::text(const Font *font, const Point *p, const CHAR *str)
{
	Bitmap::Private *dp = bmp->getPrivate();
	Point bp;
	//bp.y = font->getAscent();
	//bp.x = 0;
	//if( p->y + font->getDescent() < 0 ) return;
	//if( p->y - font->getAscent() > dp->height ) return;
	Point pt = *p;
	//pt.x -= bp.x;
	//pt.y -= bp.y;
	while(*str) {
		CHAR c = *str++;
		const Glyph *g = font->getGlyph(c);
		if( g ) {
			Point cp = pt;
			cp.y -= g->getAscent();
			cp.x += g->getOffset();
			const Bitmap *bmp = g->getBitmap();
			image(bmp, &cp);
			pt.x += g->getWidth();
		} else {
			syslog(LOG_INFO, "char error %4.4x", c);
		}
	}
}

} // ssg
