/*
 * painter.cpp
 *
 *  Created on: 2012/02/24
 *      Author: tanaka
 */
#include "painter.h"
#include "bitmap.h"
#include "painter_v1.h"
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <math.h>

namespace ssg {

static const unsigned char lmap[] = {0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01};
static const unsigned char rmap[] = {0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe};
static const unsigned char pmap[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};

void VertPainter::clear()
{
	Bitmap::Private *bp = bmp->getPrivate();
	memset(bp->bmp, 0, bp->bmp_bytes);
}

void VertPainter::fillRect(const Rect *rect)
{
	Bitmap::Private *bp = bmp->getPrivate();
	Rect r = *rect;
	if( r.x < 0 ) { r.width  -= r.x; r.x = 0; }
	if( r.y < 0 ) { r.height -= r.y; r.y = 0; }
	if( bp->width < r.x + r.width )  r.width  = bp->fb_width  - r.x;
	if( bp->fb_height < r.y + r.height ) r.height = bp->fb_height - r.y;
	if( r.width <= 0 || r.height <= 0 ) return;
	INT sx = r.x / 8;
	INT sb = r.x % 8;
	if( sb ) sx += 1;
	INT ex = (r.x + r.width) / 8;
	INT eb = (r.x + r.width) % 8;
	BYTE sm = 0;
	BYTE em = 0;
	if( sb ) {
		sm = lmap[sb];
	}
	if( eb ) {
		em = rmap[eb];
	}
	BYTE *lp = ((BYTE*)bp->bmp) + bp->mb_width * r.y;
	for(INT y=0; y<r.height; y++) {
		BYTE *xp = lp + sx;
		if( sb ) *(xp-1) = sm;
		for(INT x=sx; x<ex;x++) {
			*xp++ = 0xff;
		}
		if( eb ) *xp = em;
		lp +=  bp->mb_width;
	}
}

void VertPainter::horzLine(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	INT sx = s->x / 8;
	INT sb = s->x % 8;
	if( sb ) sx += 1;
	INT ex = e->x / 8;
	INT eb = e->x % 8;
	BYTE sm = 0;
	BYTE em = 0;
	if( sb ) {
		sm = lmap[sb];
	}
	if( eb ) {
		em = rmap[eb];
	}
	BYTE *lp = ((BYTE*)bp->bmp) + bp->mb_width * s->y;
	BYTE *xp = lp + sx;
	if( sb ) *(xp-1) = sm;
	for(INT x=sx; x<ex;x++) {
		*xp++ = 0xff;
	}
	if( eb ) *xp = em;
}

void VertPainter::vertLine(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	INT sx = s->x / 8;
	INT sb = s->x % 8;
	BYTE pm = pmap[sb];
	BYTE *xp = ((BYTE*)bp->bmp) + bp->mb_width * s->y + sx;
	for(INT y=s->y; y<=e->y;y++) {
		*xp = *xp|pm;
		xp += bp->mb_width;
	}
}

void VertPainter::line(const Point *s, const Point *e)
{
	Bitmap::Private *bp = bmp->getPrivate();
	Point sp = *s;
	Point ep = *e;
	if( sp.x == ep.x && sp.y == ep.y ) return;
	if( sp.x < 0 && ep.x < 0 ) return;
	if( sp.x > bp->width && ep.y > bp->width ) return;
	if( sp.y < 0 && ep.y < 0 ) return;
	if( sp.y > bp->height && ep.y > bp->height ) return;

	if( sp.x > ep.x ) {
		sp = *e;
		ep = *s;
	}
	if( sp.y == ep.y ) {
		if( sp.x < 0 ) sp.x = 0;
		if( ep.x > bp->width ) ep.x = bp->width;
		horzLine(&sp, &ep);
		return;
	}
	if( sp.x == ep.x ) {
		if( sp.y < 0 ) sp.y = 0;
		if( ep.y > bp->height ) ep.y = bp->height;
		vertLine(&sp, &ep);
		return;
	}

	int ay = sp.y < ep.y ? 1 : -1;
	int py = sp.y;
	int px = sp.x;
	float m = ((float)ep.y-(float)sp.y)/((float)ep.x-(float)sp.x);
	float ea = 0;
	BYTE *xpl = ((BYTE*)bp->bmp) + bp->mb_width * py;
	while(px != ep.x) {
		if( 0 <= px && px < bp->width &&
			0 <= py && py < bp->height ) {
			int bx = px / 8;
			int mx = px % 8;
			BYTE *xp = xpl + bx;
			*xp = *xp | pmap[mx];
		}
		px++;
		ea += m;
		if( abs(ea) > 0.5 ) {
			ea	-= ay;
			py	+= ay;
			xpl = ((BYTE*)bp->bmp) + bp->mb_width * py;
		}
	}
}

void VertPainter::image(const Bitmap *img, const Point *p)
{
	Bitmap::Private *dp = bmp->getPrivate();
	Bitmap::Private *sp = img->getPrivate();

	if( sp->width == 0 || sp->height == 0 ) return;
	if( dp->width == 0 || dp->height == 0 ) return;
	int put_x = p->x;
	int put_y = p->y;
	int put_bytes = put_x / 8;
	int put_frags = put_x % 8;
	Bitmap::PixIterator *pix = img->createHorzPixIterator();
	Bitmap::PixMapper *pmx = img->createPixMapper(SC_HORZ);

	for(int sy = 0; sy < sp->height; sy++) {
		pix->setPosition(0, sy);
		if( 0 <= (put_y+sy) && (put_y+sy) < dp->height ) {
			BYTE src_img = pmx->map(pix->get());
			BYTE *put_base = ((BYTE*)dp->bmp) + dp->mb_width * (put_y+sy) + put_bytes;
			for(int sx = 0; sx < sp->width && (put_bytes+sx) < dp->mb_width; sx++) {
				BYTE *put_pat = put_base+(sx/8);
				BYTE mask	= pmap[(put_frags+sx)%8];
				BYTE shift	= 7-((put_frags+sx)%8);
				BYTE dst_img = (*put_pat & mask) | (src_img << shift);
				*put_pat	= dst_img;
				src_img = pmx->map(pix->get());
			}
		}
	}
}

void VertPainter::text(const Font *font, const Point *p, const CHAR *str)
{
	Bitmap::Private *dp = bmp->getPrivate();
	if( p->y + font->getDescent() < 0 ) return;
	if( p->y - font->getAscent() > dp->height ) return;
	Point pt = *p;
	while(str) {
		CHAR c = *str++;
		const Glyph *g = font->getGlyph(c);
		if( g ) {
			Point cp = pt;
			cp.y -= g->getAscent();
			cp.x += g->getOffset();
			const Bitmap *bmp = g->getBitmap();
			image(bmp, &cp);
			pt.x += bmp->getWidth();
		}
	}
}


} // ssg
