/**************************************************
OpengateM - MAC address authentication system 

 module for mac address checking cgi main
 use for the registration of the device without Web.
 (Web device can be registered by owner oneself (opengatemown.c))
 
 CGI gets addresses from arp/ndp, and show the list on web page.
 Administrator select a candidate address from the list.
 The gate from/to the address is opened for a while and closed.
 Try the network access from the bring-in device at open time.
 If the access is passed, go to the registration(opengatemreg.c).
 Else select other address for candidate.

Copyright (C) 2011 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatemmng.h"

/***************************************************/
/*  main routine called as cgi from Web server     */
/***************************************************/
int  main(int argc, char **argv)
{
  char language[WORDMAXLN]="";  /* browser prefered language(e.g.:ja,en) */
  char requestStr[BUFFMAXLN]=""; /* http request string */
  int status=NONE;   /* request offlag for open/close: OPEN/CLOSE/NONE */
  char macAddress[ADDRMAXLN]="";  /* client MAC address */
  char userId[USERMAXLN]="";      /* user id */
  char extraId[USERMAXLN]="";     /* extra id used as user@extra */
  char* progName="";              /* the name of this program in argv[0] */
  char mailDefault[BUFFMAXLN]=""; /* default mail address to get warning */

  /* drop root privilege to prevent dangerous actions */
  seteuid(getuid());
  
  /* if this is executed in shell with '-v' option, show makedir */
  /* this is prepared to show the information about version */
  if(argc>1){
    if(strcmp(argv[1],"-v")==0){
      printf("makedir: %s\n", MAKEDIR);
    }else{
      printf("This is cgi program\n");
      printf("To show version, run this on console with '-v' option\n");
    }
    exit(0);
  }

  /* save program load path */
  saveLoadPath(argv[0]);
  progName = getProgramName();

  /* prepare configuration file */
  if(OpenConfFile()==-1){
    PutMessageToClient("Check config file by running this cgi on console");
    return 0;
  }
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(progName, LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* initialize config */
  InitConf();
  if(!InitWorkDb()) return 0;
  if(!InitMngDb()) return 0;

  /* get request language indicated in query string */
  GetLangFromQueryString(language);

  /* get post data */
  GetPostData(requestStr, BUFFMAXLN);
  
  /* authentication. get userid. if not get, exit */
  if(!GetUserId(requestStr, userId, extraId, language, ADMINUSER, 
		GetConfValue("CheckCgi"), mailDefault, "")){
    CloseMngDb();
    return 0;
  }

  /* analyze request from client */
  if(!isNull(requestStr)){
    AnalyzeCheckRequest(requestStr, &status, macAddress);
  }

  /* from second request (AJAX from html/macchk.js, status=OPEN/CLOSE), */
  /* send back short message, and exec child process to open/close network */
  if(status==OPEN){
    PutMessageToClient("open");
    StartChildProc(macAddress);
  }    
  else if(status==CLOSE){
    PutMessageToClient("close");
    StopChildProc(macAddress);
  }

  /* at first request (null status), mac list is send back */
  else{

    /* make work table for checking client mac address */
    CreateMacCheckTableInWorkDb();
  
    /* put page to client */
    PutCheckPageToClient(language,userId,extraId);
  }

  return 0;
}
