/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.value.Value;

public class Row
extends Record
implements SearchRow {
    public static final int MEMORY_CALCULATE = -1;
    private final Value[] data;
    private final int memory;

    public Row(Value[] data, int memory) {
        this.data = data;
        this.memory = memory;
    }

    public Row(Row old) {
        this.data = old.data;
        this.memory = old.memory;
    }

    public Value getValue(int i) {
        return this.data[i];
    }

    public void write(DataPage buff) throws SQLException {
        buff.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            Value v = this.data[i];
            buff.writeValue(v);
        }
    }

    public int getByteCount(DataPage dummy) throws SQLException {
        int len = this.data.length;
        int size = dummy.getIntLen();
        for (int i = 0; i < len; ++i) {
            Value v = this.data[i];
            size += dummy.getValueLen(v);
        }
        return size;
    }

    public void setValue(int i, Value v) {
        this.data[i] = v;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public int getColumnCount() {
        return this.data.length;
    }

    public int getMemorySize() {
        if (this.memory != -1) {
            return this.blockCount * 8 + this.memory * 4;
        }
        int m = this.blockCount * 8;
        for (int i = 0; this.data != null && i < this.data.length; ++i) {
            m += this.data[i].getMemory();
        }
        return m;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.data.length * 5);
        buff.append("( /* pos:");
        buff.append(this.getPos());
        if (this.getDeleted()) {
            buff.append(" deleted");
        }
        buff.append(" */ ");
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.data[i].getSQL());
        }
        buff.append(')');
        return buff.toString();
    }
}

