/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.util.List;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.meta.DbColumnMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMetaReader;
import org.seasar.framework.log.Logger;

public class DumpDbMetaCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(DumpDbMetaCommand.class);
    protected String schemaName = null;
    protected String tableNamePattern = ".*";
    protected String ignoreTableNamePattern = ".*\\$.*";
    protected String genDialectClassName = null;
    protected GenDialect dialect;
    protected DbTableMetaReader dbTableMetaReader;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public String getIgnoreTableNamePattern() {
        return this.ignoreTableNamePattern;
    }

    public void setIgnoreTableNamePattern(String ignoreTableNamePattern) {
        this.ignoreTableNamePattern = ignoreTableNamePattern;
    }

    public String getGenDialectClassName() {
        return this.genDialectClassName;
    }

    public void setGenDialectClassName(String genDialectClassName) {
        this.genDialectClassName = genDialectClassName;
    }

    protected void doValidate() {
    }

    protected void doInit() {
        this.dialect = this.getGenDialect(this.genDialectClassName);
        this.dbTableMetaReader = this.createDbTableMetaReader();
        this.logRdbmsAndGenDialect(this.dialect);
    }

    protected void doExecute() {
        List<DbTableMeta> tableMetaList = this.dbTableMetaReader.read();
        for (DbTableMeta table : tableMetaList) {
            logger.log("IS2JDBCGen0001", new Object[]{table.getCatalogName(), table.getSchemaName(), table.getName(), table.getColumnMetaList().size()});
            for (DbColumnMeta column : table.getColumnMetaList()) {
                logger.log("IS2JDBCGen0002", new Object[]{column.getName(), Integer.toString(column.getSqlType()), column.getTypeName(), column.getLength(), column.getScale(), column.isNullable(), column.isPrimaryKey()});
            }
        }
    }

    protected void doDestroy() {
    }

    protected DbTableMetaReader createDbTableMetaReader() {
        return this.factory.createDbTableMetaReader(this, this.jdbcManager.getDataSource(), this.dialect, this.schemaName, this.tableNamePattern, this.ignoreTableNamePattern, false);
    }

    protected Logger getLogger() {
        return logger;
    }
}

