/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.meta;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.MappedSuperclass;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.internal.meta.CommentDocletContext;
import org.seasar.extension.jdbc.gen.internal.util.EntityMetaUtil;
import org.seasar.extension.jdbc.gen.internal.util.PropertyMetaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentDoclet
extends Doclet {
    public static boolean start(RootDoc rootDoc) {
        List<EntityMeta> entityMetaList = CommentDocletContext.getEntityMetaList();
        if (entityMetaList == null) {
            throw new NullPointerException("entityMetaList");
        }
        for (EntityMeta entityMeta : entityMetaList) {
            ClassDoc classDoc = rootDoc.classNamed(entityMeta.getEntityClass().getName());
            if (classDoc == null) continue;
            CommentDoclet.doEntityComment(classDoc, entityMeta);
        }
        return true;
    }

    protected static void doEntityComment(ClassDoc classDoc, EntityMeta entityMeta) {
        EntityMetaUtil.setComment(entityMeta, classDoc.commentText());
        Map<String, FieldDoc> fieldDocMap = CommentDoclet.getFieldDocMap(classDoc);
        for (PropertyMeta propertyMeta : entityMeta.getAllPropertyMeta()) {
            if (!fieldDocMap.containsKey(propertyMeta.getName())) continue;
            FieldDoc fieldDoc = fieldDocMap.get(propertyMeta.getName());
            CommentDoclet.doPropertyComment(fieldDoc, propertyMeta);
        }
    }

    protected static void doPropertyComment(FieldDoc fieldDoc, PropertyMeta propertyMeta) {
        PropertyMetaUtil.setComment(propertyMeta, fieldDoc.commentText());
    }

    protected static Map<String, FieldDoc> getFieldDocMap(ClassDoc classDoc) {
        HashMap<String, FieldDoc> fieldMap = new HashMap<String, FieldDoc>();
        for (FieldDoc fieldDoc : classDoc.fields()) {
            fieldMap.put(fieldDoc.name(), fieldDoc);
        }
        ClassDoc superclassDoc = classDoc.superclass();
        while (!Object.class.getName().equals(superclassDoc.qualifiedName())) {
            if (CommentDoclet.isMappedSuperclass(superclassDoc)) {
                for (FieldDoc fieldDoc : superclassDoc.fields()) {
                    if (fieldMap.containsKey(fieldDoc.name())) continue;
                    fieldMap.put(fieldDoc.name(), fieldDoc);
                }
            }
            superclassDoc = superclassDoc.superclass();
        }
        return fieldMap;
    }

    protected static boolean isMappedSuperclass(ClassDoc classDoc) {
        for (AnnotationDesc desc : classDoc.annotations()) {
            if (!MappedSuperclass.class.getName().equals(desc.annotationType().qualifiedName())) continue;
            return true;
        }
        return false;
    }
}

