/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import javax.annotation.Generated;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.gen.internal.model.ClassModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.ServiceTestModel;
import org.seasar.extension.jdbc.gen.model.ServiceTestModelFactory;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.unit.Seasar2;

public class ServiceTestModelFactoryImpl
implements ServiceTestModelFactory {
    protected String packageName;
    protected String serviceClassNameSuffix;
    protected String testClassNameSuffix;
    protected String configPath;
    protected boolean useS2junit4;
    protected ClassModelSupport classModelSupport = new ClassModelSupport();
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();

    public ServiceTestModelFactoryImpl(String configPath, String packageName, String serviceClassNameSuffix, String testClassNameSuffix, boolean useS2junit4) {
        if (configPath == null) {
            throw new NullPointerException("configPath");
        }
        if (serviceClassNameSuffix == null) {
            throw new NullPointerException("serviceClassNameSuffix");
        }
        if (testClassNameSuffix == null) {
            throw new NullPointerException("testClassNameSuffix");
        }
        this.configPath = configPath;
        this.packageName = packageName;
        this.serviceClassNameSuffix = serviceClassNameSuffix;
        this.testClassNameSuffix = testClassNameSuffix;
        this.useS2junit4 = useS2junit4;
    }

    public ServiceTestModel getServiceTestModel(EntityMeta entityMeta) {
        ServiceTestModel serviceTestModel = new ServiceTestModel();
        serviceTestModel.setConfigPath(this.configPath);
        serviceTestModel.setPackageName(this.packageName);
        String shortServiceClassName = entityMeta.getEntityClass().getSimpleName() + this.serviceClassNameSuffix;
        serviceTestModel.setShortServiceClassName(shortServiceClassName);
        serviceTestModel.setShortClassName(shortServiceClassName + this.testClassNameSuffix);
        serviceTestModel.setUseS2junit4(this.useS2junit4);
        this.doImportName(serviceTestModel, entityMeta);
        this.doGeneratedInfo(serviceTestModel, entityMeta);
        return serviceTestModel;
    }

    protected void doImportName(ServiceTestModel serviceTestModel, EntityMeta entityMeta) {
        this.classModelSupport.addImportName((ClassModel)serviceTestModel, Generated.class);
        if (this.useS2junit4) {
            this.classModelSupport.addImportName((ClassModel)serviceTestModel, RunWith.class);
            this.classModelSupport.addImportName((ClassModel)serviceTestModel, Seasar2.class);
            this.classModelSupport.addStaticImportName((ClassModel)serviceTestModel, Assert.class);
        } else {
            this.classModelSupport.addImportName((ClassModel)serviceTestModel, S2TestCase.class);
        }
    }

    protected void doGeneratedInfo(ServiceTestModel serviceTestModel, EntityMeta entityMeta) {
        this.generatedModelSupport.fillGeneratedInfo(this, serviceTestModel);
    }
}

