package net.waltzstudio.montecarlo.dao.label;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.dao.AuditDao;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.label.Label;
import net.waltzstudio.montecarlo.entity.label.LabelName;

/**
 * ラベルDaoBase
 */
public abstract class LabelDaoBase extends AuditDao<Label> implements LabelName {

	public Label findById(Long id) {
		return select().id(id).where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getSingleResult();
	}

	public List<Label> findAllOrderById() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).orderBy(asc($ID)).getResultList();
	}

}
