package net.waltzstudio.base.framework.dao;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.Date;
import java.util.List;
import net.waltzstudio.base.framework.entity.AuditEntity;
import net.waltzstudio.base.framework.entity.AuditEntityName;
import net.waltzstudio.base.framework.types.DeleteFlg;

public abstract class AuditDao<T extends AuditEntity> extends Dao<T> implements AuditEntityName {

	@Override
	public List<T> findAll() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getResultList();
	}

	@Override
	public long getCount() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getCount();
	}

	@Override
	public int insert(T entity) {
		Date updateDatetime = new Date();
		entity.deleteFlg = DeleteFlg.NORMAL;
		entity.createDatetime = updateDatetime;
		entity.updateDatetime = updateDatetime;
		return jdbcManager.insert(entity).execute();
	}
	@Override
	public int update(T entity) {
		Date updateDatetime = new Date();
		entity.updateDatetime = updateDatetime;
		return jdbcManager.update(entity).execute();
	}

	@Override
	public int delete(T entity) {
		entity.deleteFlg = DeleteFlg.DELETED;
		return update(entity);
	}

}
