package net.waltzstudio.montecarlo.dao.ticketUnread;

// import static org.seasar.extension.jdbc.operation.Operations.*;
import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import java.util.List;
import net.waltzstudio.montecarlo.entity.ticketUnread.TicketUnread;

/**
 * チケット未読Dao
 */
public abstract class TicketUnreadDao extends TicketUnreadDaoBase {

	public List<TicketUnread> findByAccountId(Long accountId) {
		String sql = SB(true, " ", //
				"  SELECT *                            ", //
				"    FROM ticket_unread tu             ", //
				"   WHERE tu.delete_flg = '0'          ", //
				"     AND tu.account_id = ?            ");
		return jdbcManager.selectBySql(TicketUnread.class, sql, accountId).getResultList();
	}

}
