//******************************************************************************
//
// MIDITrail / MTPianoKeyboardCtrlLive
//
// Cuj^psAmL[{[hNX
//
// Copyright (C) 2012-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// ̃sAmL[{[hǗNXB
// eL[{[h̔zuƃL[̉Ԃ𐧌䂷B
// 1|[g(16ch)̕`݂̂ɑΉĂB
// 2|[gڈȍ~̕`ɂ͑ΉĂȂB

#pragma once

#include "SMIDILib.h"
#include "MTPianoKeyboard.h"
#include "MTPianoKeyboardDesign.h"
#include "MTNotePitchBend.h"
#include "MTNoteDesign.h"


//******************************************************************************
// Cuj^psAmL[{[hNX
//******************************************************************************
class MTPianoKeyboardCtrlLive
{
public:
	
	//RXgN^^fXgN^
	MTPianoKeyboardCtrlLive(void);
	virtual ~MTPianoKeyboardCtrlLive(void);
	
	//
	int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			MTNotePitchBend* pNotePitchBend,
			bool isSingleKeyboard
		);
	
	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);
	
	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//
	void Release();
	
	//Zbg
	void Reset();
	
	//\ݒ
	void SetEnable(bool isEnable);
	
	//m[gONo^
	void SetNoteOn(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo,
			unsigned char velocity
		);
	
	//m[gOFFo^
	void SetNoteOff(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo
		);
	
	//Sm[gOFF
	void AllNoteOff();
	void AllNoteOffOnCh(unsigned char portNo, unsigned char chNo);
	
private:
	
	//L[
	enum KeyStatus {
		BeforeNoteON,
		NoteON,
		AfterNoteOFF
	};
	
	//m[g\
	struct NoteStatus {
		bool isActive;
		unsigned long startTime;
		unsigned long endTime;
		float keyDownRate;
	};
	
private:
	
	//m[gfUC
	MTNoteDesign m_NoteDesign;
	
	//L[{[h`IuWFNgF|C^z
	MTPianoKeyboard* m_pPianoKeyboard[SM_MAX_CH_NUM];
	
	//L[{[hfUC
	MTPianoKeyboardDesign m_KeyboardDesign;
	
	//m[g
	NoteStatus m_NoteStatus[SM_MAX_CH_NUM][SM_MAX_NOTE_NUM];
	
	//sb`xh
	MTNotePitchBend* m_pNotePitchBend;
	
	//\
	bool m_isEnable;
	
	//VOL[{[htO
	bool m_isSingleKeyboard;
	
	void _ClearNoteStatus();
	int _CreateKeyboards(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName);
	
	int _TransformActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateStatusOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateNoteStatus(
				unsigned long playTimeMSec,
				unsigned long keyDownDuration,
				unsigned long keyUpDuration,
				SMNote note,
				NoteStatus* pNoteStatus
			);
	int _UpdateVertexOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	float _GetPichBendShiftPosX(unsigned char portNo, unsigned char chNo);

};


