//******************************************************************************
//
// Simple Base Library / YNPathUtil
//
// pX[eBeBNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNErrCtrl.h"
#include "YNPathUtil.h"
#include <stdlib.h>
#include <shlobj.h>
#include <stdio.h>

namespace YNBaseLib {


//******************************************************************************
// RXgN^
//******************************************************************************
YNPathUtil::YNPathUtil(void)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
YNPathUtil::~YNPathUtil(void)
{
}

//******************************************************************************
// vZXst@CfBNgpX擾
//******************************************************************************
int YNPathUtil::GetModuleDirPath(
		TCHAR* pBuf,
		unsigned long bufSize
	)
{
	int result = 0;
	DWORD apiresult = 0;
	errno_t eresult = 0;
	TCHAR path[_MAX_PATH];
	TCHAR drive[_MAX_DRIVE];
	TCHAR dir[_MAX_DIR];
	TCHAR fname[_MAX_FNAME];
	TCHAR ext[_MAX_EXT];

	//vZXst@CpX擾
	apiresult = GetModuleFileName(GetModuleHandle(NULL), path, _MAX_PATH);
	if (apiresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//pXvf̕
	eresult = _tsplitpath_s(
					path,		//pX
					drive,		//hCuobt@
					_MAX_DRIVE,	//obt@TCY
					dir,		//fBNgobt@
					_MAX_DIR,	//obt@TCY
					fname,		//t@Cobt@
					_MAX_FNAME,	//obt@TCY
					ext,		//gqobt@
					_MAX_EXT	//obt@TCY
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//pX쐬
	eresult = _tmakepath_s(
					pBuf,		//pXi[obt@
					bufSize,	//obt@TCY
					drive,		//hCu
					dir,		//fBNg
					NULL,		//t@C
					NULL		//gq
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// AvP[Vf[^fBNgpX擾
//******************************************************************************
int YNPathUtil::GetAppDataDirPath(
		TCHAR* pBuf,
		unsigned long bufSize
	)
{
	int result = 0;
	HRESULT hresult = 0;
	errno_t eresult = 0;
	TCHAR path[MAX_PATH];

	hresult = SHGetFolderPath(
					NULL,				//I[i[EBhE
					CSIDL_APPDATA,		//tH_w
					NULL,				//ANZXg[N
					SHGFP_TYPE_CURRENT,	//tOF݂̃tH_pX
										//  [UύXĂ\
					path				//pXi[obt@
				);
	if (hresult != S_OK) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	eresult = _tcscpy_s(pBuf, bufSize, path);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	eresult = _tcscat_s(pBuf, bufSize, _T("\\"));
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// gq
//******************************************************************************
bool YNPathUtil::IsFileExtMatch(
		const TCHAR* pPath,
		const TCHAR* pExt
	)
{
	bool isMatch = false;
	errno_t eresult = 0;
	TCHAR ext[_MAX_EXT] = {_T('\0')};

	//pXvf𕪊Ċgq擾
	eresult = _tsplitpath_s(
					pPath,			//pX
					NULL, 0,		//hCuobt@ƃTCY
					NULL, 0,		//fBNgobt@ƃTCY
					NULL, 0,		//t@Cobt@ƃTCY
					ext, _MAX_EXT	//gqobt@ƃTCY
				);
	if (eresult != 0) {
		//result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//啶ƏʂɊgqr
	if (_tcsicmp(ext, pExt) == 0) {
		isMatch = true;
	}

EXIT:;
	return isMatch;
}

//******************************************************************************
// e|t@CpX擾
//******************************************************************************
int YNPathUtil::GetTempFilePath(
		TCHAR* pPathBuf,
		unsigned long bufSize,
		const TCHAR* pPrefix
	)
{
	int result = 0;
	DWORD apiresult = 0;
	TCHAR tempDir[_MAX_PATH] = {_T('\0')};

	//e|fBNgpX擾
	apiresult = GetTempPath(_MAX_PATH, tempDir);
	if (apiresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//GetTmpFileName̓obt@TCYwłȂAPIł
	//uobt@TCYMAX_PATHȏɂvƒ`Ă̂
	//TCY`FbNs
	if (bufSize < MAX_PATH) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//e|t@CpX擾
	//  t@CFPREuuuu.TMP
	//    PRE FvtBbNX
	//    uuuuFVXeɊÂĐꂽ16i
	apiresult = GetTempFileName(
						tempDir,	//fBNgpX
						pPrefix,	//vtBbNXi3j
						0,			//ӐFL
						pPathBuf	//ꂽt@CpX
					);
	if (apiresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

} // end of namespace

